package com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.entity.Contact;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.com.bumptech.glide.Glide;

public class LoungeIntegrationSingleView extends FrameLayout {

  private View root;

  private ImageView imageIcon;

  private TextView textTitle;

  private TextView textDescription;

  @Nullable
  private OnIntegrationClickListener listener;

  public LoungeIntegrationSingleView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public LoungeIntegrationSingleView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public LoungeIntegrationSingleView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  public void setListener(@Nullable OnIntegrationClickListener listener) {
    this.listener = listener;
  }

  @Initializer
  private void init(Context context) {
    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_lounge_integration_single, this);

    imageIcon = root.findViewById(R.id.ch_imageIntegrationSingleIcon);
    textTitle = root.findViewById(R.id.ch_textIntegrationSingleTitle);
    textDescription = root.findViewById(R.id.ch_textIntegrationSingleDescription);
  }

  public void setAppMessenger(@NonNull Contact contact) {
    contact.setIcon(imageIcon);

    Views.setVisibility(textTitle, contact.getTitle() != null);
    textTitle.setText(contact.getTitle());

    Views.setVisibility(textDescription, contact.getDescription() != null);
    textDescription.setText(contact.getDescription());

    root.setOnClickListener(v -> {
      contact.doAction(listener);
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    Glide.clear(imageIcon);
    super.onDetachedFromWindow();
  }
}
