package com.zoyi.channel.plugin.android.activity.lounge;

import android.content.Intent;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.*;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.utils.ChatUtils;
import com.zoyi.channel.plugin.android.activity.chats.ChatsActivity;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.userchat.listener.OnChatClickListener;
import com.zoyi.channel.plugin.android.activity.common.userchat.model.ChatItem;
import com.zoyi.channel.plugin.android.activity.common.watermark.ChannelWatermarkView;
import com.zoyi.channel.plugin.android.activity.lounge.contract.LoungeContract;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderInteractionListener;
import com.zoyi.channel.plugin.android.activity.lounge.view.LoungeHeaderView;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.*;
import com.zoyi.channel.plugin.android.activity.lounge.view.app_messenger.model.LinkContact;
import com.zoyi.channel.plugin.android.activity.lounge.view.lounge_media.LoungeMediaErrorCardView;
import com.zoyi.channel.plugin.android.activity.settings.SettingsActivity;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.*;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.entity.LoungeMedia;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.media.instagram.Instagram;
import com.zoyi.channel.plugin.android.selector.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.coordinator.LoungeCoordinatorLayout;
import com.zoyi.channel.plugin.android.view.coordinator.PaddingNestedScrollView;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.integrations.instagram.InstagramView;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;
import com.zoyi.channel.plugin.android.view.load_wrapper.LoadWrapperLayout;
import com.zoyi.channel.plugin.android.view.textview.EllipsizeTextView;
import com.zoyi.channel.plugin.android.view.viewgroup.MaxWidthLinearLayout;

import java.util.List;

public class LoungeActivity
    extends
    BaseActivity2
    implements
    LoungeContract.View,
    OnChatClickListener,
    LoungeHeaderInteractionListener,
    OnIntegrationClickListener {

  private LoungeCoordinatorLayout layoutCoordinator;
  private LoungeHeaderView headerLounge;

  private View buttonCloseLounge;

  private LoadWrapperLayout loadWrapperLayout;

  private View layoutPreviewHeader;

  // chat
  private View layoutPreviewChat;
  private RecyclerView recyclerViewChat;
  private View buttonChatStartChats;
  private TextView textLoungePreviewChatStartChats;
  private ImageView chatStartButton;
  private ChatStartButton buttonChatStartWelcome;
  private FrameLayout layoutLoungeSeeMoreChats;
  private CardView cardLoungeSeeMoreChats;
  private TextView textLoungeSeeMoreChats;

  // welcome message
  private View layoutPreviewWelcome;
  private AvatarLayout avatarWelcomeMessageProfile;
  private TextView textWelcomeMessageProfile;
  private EllipsizeTextView textWelcomeMessage;

  // Apps Integrations
  private CardView cardAppMessengers;
  private LoungeIntegrationSingleView viewSingleAppMessenger;
  private LoungeIntegrationView viewAppMessengers;

  // Instagram View
  private LoadWrapperLayout loadWrapperInstagram;
  private InstagramView viewInstagram;

  // bottom layout
  private PaddingNestedScrollView scrollViewLounge;
  private MaxWidthLinearLayout maxWidthLounge;
  private ChannelWatermarkView watermark;
  private View dummyWatermark;

  private LoungeAdapter adapter;
  private LoungeContract.Presenter presenter;

  private LinearLayoutManager layoutManager;

  @Nullable
  private Binder appMessengersBinder;

  @Nullable
  private Binder moreChatBinder;

  @Nullable
  private Binder startChatBinder;

  @Nullable
  private Binder channelBinder;

  private boolean canStartChat = true;

  @Nullable
  private String contentId = null;
  @Nullable
  private String presetMessage = null;
  private boolean handleOpenChat = false;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_lounge);

    setOutTransition(Transition.SLIDE_FROM_BOTTOM);

    layoutCoordinator = findViewById(R.id.ch_layoutLoungeCoordinator);

    headerLounge = findViewById(R.id.ch_viewLoungeHeader);
    headerLounge.setLoungeHeaderInteractionListener(this);

    buttonCloseLounge = findViewById(R.id.ch_buttonLoungeCloseOverlay);
    buttonCloseLounge.setOnClickListener(v -> Action.invoke(ActionType.EXIT));

    loadWrapperLayout = findViewById(R.id.ch_loadWrapperLounge);
    loadWrapperLayout.setOnErrorRefreshClickListener(() -> presenter.fetchPreviewData());

    layoutPreviewHeader = findViewById(R.id.ch_viewLoungePreviewHeader);

    layoutPreviewChat = findViewById(R.id.ch_layoutLoungePreviewChat);

    layoutPreviewWelcome = findViewById(R.id.ch_layoutLoungePreviewWelcomeMessage);
    layoutPreviewWelcome.setOnClickListener(v -> startChat(Transition.SLIDE_FROM_RIGHT));

    avatarWelcomeMessageProfile = findViewById(R.id.ch_avatarLoungePreviewWelcomeMessage);
    textWelcomeMessageProfile = findViewById(R.id.ch_textLoungePreviewWelcomeMessageName);
    textWelcomeMessage = findViewById(R.id.ch_textLoungePreviewWelcomeMessageMessage);

    cardAppMessengers = findViewById(R.id.ch_cardLoungeIntegrations);
    viewAppMessengers = findViewById(R.id.ch_viewLoungeIntegrations);
    viewAppMessengers.setListener(this);
    viewSingleAppMessenger = findViewById(R.id.ch_viewLoungeSingleIntegration);
    viewSingleAppMessenger.setListener(this);

    // bottom layout
    watermark = findViewById(R.id.ch_viewLoungeWatermark);
    maxWidthLounge = findViewById(R.id.ch_layoutMaxWidthLoungeLinear);
    scrollViewLounge = findViewById(R.id.ch_scrollViewLounge);
    dummyWatermark = findViewById(R.id.ch_viewLoungeDummyWatermark);

    scrollViewLounge.setListener(scrollPosition -> setWatermarkAlphaAnimation(scrollPosition));
    maxWidthLounge.getViewTreeObserver().addOnGlobalLayoutListener(() -> setWatermarkAlphaAnimation(scrollViewLounge.getScrollY()));

    appMessengersBinder = AppMessengerSelector.bindIntegrations(this, (contacts) -> {
      if (contacts.size() == 1 && !(contacts.get(0) instanceof LinkContact)) {
        // Exclude LinkContact in Single App Messenger View because of unintended click
        // https://www.notion.so/channelio/733ff45a40d64db9b11ec9818258a7eb
        viewSingleAppMessenger.setVisibility(View.VISIBLE);
        viewSingleAppMessenger.setAppMessenger(contacts.get(0));
        viewAppMessengers.setVisibility(View.GONE);
      } else if (contacts.size() > 1) {
        viewAppMessengers.setVisibility(View.VISIBLE);
        viewAppMessengers.setAppMessengers(contacts);
        viewSingleAppMessenger.setVisibility(View.GONE);
      } else {
        // Hide all app messenger view
        viewSingleAppMessenger.setVisibility(View.GONE);
        viewAppMessengers.setVisibility(View.GONE);
      }
    });

    layoutCoordinator.setOnNestedScrollChangeListener((scrollPosition, headerHeight) -> {
      float maxScrollPosition = Math.min(scrollPosition, headerHeight);
      float closeButtonAlpha = maxScrollPosition / headerHeight;

      headerLounge.setAlpha(1 - closeButtonAlpha);
      buttonCloseLounge.setAlpha(closeButtonAlpha);
      buttonCloseLounge.setVisibility(scrollPosition == 0 ? View.GONE : View.VISIBLE);
    });

    adapter = new LoungeAdapter();
    adapter.setListener(this);

    buttonChatStartChats = findViewById(R.id.ch_buttonLoungePreviewChatStartChats);
    buttonChatStartChats.setOnClickListener(v -> {
      if (canStartChat) {
        startChat(Transition.SLIDE_FROM_RIGHT);
      }
    });

    chatStartButton = findViewById(R.id.ch_imageLoungePreviewChatStartButton);
    textLoungePreviewChatStartChats = findViewById(R.id.ch_textLoungePreviewChatStartChats);

    startChatBinder = ChannelSelector.bindDisableStartChat(disabled -> {
      this.canStartChat = !disabled;

      chatStartButton.setColorFilter(ResUtils.getColor(disabled ? R.color.ch_grey500 : R.color.ch_grey900));
      textLoungePreviewChatStartChats.setTextColor(ResUtils.getColor(disabled ? R.color.ch_grey500 : R.color.ch_grey900));
    });

    layoutManager = new LinearLayoutManager(this);

    recyclerViewChat = findViewById(R.id.ch_recyclerViewLoungePreviewChat);
    recyclerViewChat.setLayoutManager(layoutManager);
    recyclerViewChat.setAdapter(adapter);
    recyclerViewChat.setItemAnimator(null);
    recyclerViewChat.getRecycledViewPool().setMaxRecycledViews(0, 40);

    // App Media View
    loadWrapperInstagram = findViewById(R.id.ch_loadWrapperLoungeMediaInstagram);
    viewInstagram = findViewById(R.id.ch_viewLoungeInstagram);

    loadWrapperInstagram.setOnErrorRefreshClickListener(() -> presenter.fetchLoungeMediaData(Const.APP_MEDIA_INSTAGRAM));
    setLoungeMediaErrorViewDescription(loadWrapperInstagram.getErrorView(), Const.APP_MEDIA_INSTAGRAM);

    buttonChatStartWelcome = findViewById(R.id.ch_buttonLoungePreviewChatStartWelcome);
    buttonChatStartWelcome.setOnClickListener(v -> startChat(Transition.SLIDE_FROM_RIGHT));

    layoutLoungeSeeMoreChats = findViewById(R.id.ch_layoutLoungeSeeMoreChats);
    cardLoungeSeeMoreChats = findViewById(R.id.ch_cardLoungeSeeMoreChats);
    cardLoungeSeeMoreChats.setOnClickListener(v -> showChats());
    textLoungeSeeMoreChats = findViewById(R.id.ch_textLoungeSeeMoreChats);

    moreChatBinder = ChatsSelector.bindUserChatsMore(
        (hasNext, invisibleCount) -> {
          if (invisibleCount > 0) {
            cardLoungeSeeMoreChats.setVisibility(View.VISIBLE);
            textLoungeSeeMoreChats.setText(
                String.format(
                    ResUtils.getString(hasNext ? "ch.lounge.show_previous_chats_more" : "ch.lounge.show_previous_chats"),
                    invisibleCount
                )
            );
          } else {
            cardLoungeSeeMoreChats.setVisibility(View.GONE);
          }
        }
    );

    presenter = new LoungePresenter(this, adapter, adapter, getString(Const.EXTRA_TOP_ACTIVITY_NAME));
    bindPresenter(presenter);

    // Set states

    GlobalStore.get().messengerState.set(true);
    PopupStore.get().popupMessage.set(null);

    // handle intent

    Intent intent = getIntent();

    if (intent != null) {
      contentId = intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID);
      presetMessage = intent.getStringExtra(Const.EXTRA_CHAT_PRESET_MESSAGE);
      handleOpenChat = intent.getBooleanExtra(Const.EXTRA_HANDLE_OPEN_CHAT, false);
    }

    return true;
  }

  @Override
  protected void onNewIntent(Intent intent) {
    super.onNewIntent(intent);

    if (intent != null) {
      contentId = intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID);
      presetMessage = intent.getStringExtra(Const.EXTRA_CHAT_PRESET_MESSAGE);
      handleOpenChat = intent.getBooleanExtra(Const.EXTRA_HANDLE_OPEN_CHAT, false);
    }
  }

  @Override
  protected void onResume() {
    super.onResume();

    if (viewInstagram != null) {
      viewInstagram.onResume();
    }
  }

  @Override
  protected void onPause() {
    super.onPause();

    if (viewInstagram != null) {
      viewInstagram.onPause();
    }

    if (isFinishing()) {
      GlobalStore.get().messengerState.set(false);

      Action.invoke(ActionType.MESSENGER_CLOSED);
    }
  }

  @Override
  protected void onDestroy() {
    super.onDestroy();

    if (viewInstagram != null) {
      viewInstagram.clear();
    }

    if (appMessengersBinder != null) {
      appMessengersBinder.unbind();
      appMessengersBinder = null;
    }

    if (moreChatBinder != null) {
      moreChatBinder.unbind();
      moreChatBinder = null;
    }

    if (startChatBinder != null) {
      startChatBinder.unbind();
      startChatBinder = null;
    }

    if (channelBinder != null) {
      channelBinder.unbind();
      channelBinder = null;
    }
  }

  // handle change

  @Override
  public void onPreviewStateChange(PreviewState previewState) {
    layoutPreviewChat.setVisibility(View.GONE);
    layoutPreviewHeader.setVisibility(View.GONE);
    layoutPreviewWelcome.setVisibility(View.GONE);
    buttonChatStartWelcome.setVisibility(View.GONE);
    layoutLoungeSeeMoreChats.setVisibility(View.GONE);
    cardAppMessengers.setVisibility(View.GONE);

    switch (previewState) {
      case CHATS:
        loadWrapperLayout.setLoadState(FetchState.COMPLETE);
        layoutPreviewHeader.setVisibility(View.VISIBLE);
        layoutPreviewChat.setVisibility(View.VISIBLE);
        layoutLoungeSeeMoreChats.setVisibility(View.VISIBLE);
        cardAppMessengers.setVisibility(View.VISIBLE);
        break;

      case WELCOME:
        loadWrapperLayout.setLoadState(FetchState.COMPLETE);
        layoutPreviewWelcome.setVisibility(View.VISIBLE);
        buttonChatStartWelcome.setVisibility(View.VISIBLE);
        layoutLoungeSeeMoreChats.setVisibility(View.VISIBLE);
        cardAppMessengers.setVisibility(View.VISIBLE);
        break;

      case LOADING:
        loadWrapperLayout.setLoadState(FetchState.LOADING);
        break;

      case FAILED:
        loadWrapperLayout.setLoadState(FetchState.FAILED);
        break;
    }

    if (previewState == PreviewState.WELCOME || previewState == PreviewState.CHATS) {
      if (handleOpenChat) {
        if (contentId != null) {
          startChat(ChatContentType.USER_CHAT, contentId, Transition.NONE);
        } else if (presetMessage != null) {
          startChat(presetMessage, Transition.NONE);
        } else {
          startChat(Transition.NONE);
        }
        contentId = null;
        presetMessage = null;
        handleOpenChat = false;
      }
    }
  }

  @Override
  public void onLoungeMediaStateChange(String type, FetchState fetchState) {
    switch (fetchState) {
      case COMPLETE:
      case FAILED:
      case LOADING:
        if (Const.APP_MEDIA_INSTAGRAM.equals(type)) {
          loadWrapperInstagram.setVisibility(View.VISIBLE);
          loadWrapperInstagram.setLoadState(fetchState);
        }
        break;

      case EMPTY:
        if (Const.APP_MEDIA_INSTAGRAM.equals(type)) {
          loadWrapperInstagram.setVisibility(View.GONE);
        }
        break;
    }
  }

  @Override
  public void onFetchLoungeMediaInstagram(List<LoungeMedia> loungeMedia) {
    for (LoungeMedia media : loungeMedia) {
      if (media instanceof Instagram) {
        if (!((Instagram)media).getData().isEmpty()) {
          viewInstagram.setVisibility(View.VISIBLE);
          viewInstagram.setInstagram((Instagram) media);
        } else {
          viewInstagram.setVisibility(View.GONE);
        }
      }
    }
  }

  @Override
  public void handleWatermarkVisibility() {
    Channel channel = ChannelStore.get().channelState.get();

    if (channel != null && channel.isWhiteLabelFeature()) {
      deactivateWatermark();
    } else {
      activateWatermark();
    }
  }

  @Override
  public void deactivateWatermark() {
    watermark.setActivateState(false);
    dummyWatermark.setVisibility(View.GONE);
  }

  @Override
  public void onDefaultProfileChange(ProfileEntity profileEntity) {
    if (profileEntity != null) {
      avatarWelcomeMessageProfile.set(profileEntity);
      textWelcomeMessageProfile.setText(profileEntity.getName());
    }
  }

  @Override
  public void onWelcomeMessageChange(String plainText) {
    if (plainText != null) {
      textWelcomeMessage.setText(plainText);
    }
  }

  @Override
  public void onChatItemClick(@NonNull ChatItem chatItem) {
    startChat(chatItem.getType(), chatItem.getSubKey(), Transition.SLIDE_FROM_RIGHT);
  }

  @Override
  public void onChatItemLongClick(@NonNull ChatItem chatItem) {
    new ChannelDialog(this)
        .setDescription(ResUtils.getString("ch.chat.delete_description"))
        .addButton(ButtonType.CANCEL)
        .addButton(ButtonType.OK, (v) -> presenter.removeChat(chatItem))
        .allowBackpress(true)
        .show();
  }

  @Override
  public void onLinkClick(String link) {
    if (ClipboardUtils.copyToClipBoard(link)) {
      Toast.makeText(this, ResUtils.getString("ch.integrations.copy_link.success"), Toast.LENGTH_SHORT).show();
    }
  }

  @Override
  public void onCallClick(String number) {
    if (number != null && Executor.canCall(this)) {
      Executor.openCall(this, number);
    } else {
      showPermissionDeniedToast();
    }
  }

  @Override
  public void onMessengerClick(String name) {
    presenter.fetchConnect(name);
  }

  @Override
  public void onSettingsClick() {
    IntentUtils.setNextActivity(this, SettingsActivity.class).startActivity();
  }

  @Override
  public void onExitClick() {
    Action.invoke(ActionType.EXIT);
  }

  @Override
  protected void onActivityResult(int requestCode, int resultCode, @Nullable Intent data) {
    super.onActivityResult(requestCode, resultCode, data);

    if (requestCode == Const.REQUEST_CHAT && resultCode == Const.RESULT_CHAT_OPEN_NEW_CHAT) {
      startChat(Transition.NONE);
    }
  }

  // private methods

  private void activateWatermark() {
    watermark.setActivateState(true);
    dummyWatermark.setVisibility(View.VISIBLE);
  }

  private void setWatermarkAlphaAnimation(int scrollPosition) {
    watermark.setOpacityState(maxWidthLounge.getBottom() - scrollViewLounge.getHeight() - scrollPosition < watermark.getHeight() + Utils.dpToPx(100));
  }

  private void showChats() {
    IntentUtils.setNextActivity(this, ChatsActivity.class).startActivity();
  }

  private void startChat(Transition transition) {
    startChat(null, transition);
  }

  private void startChat(@Nullable String presetMessage, Transition transition) {
    ChatUtils.createChatActivityIntent(this)
        .putExtra(Const.EXTRA_CHAT_PRESET_MESSAGE, presetMessage)
        .setTransition(transition)
        .startActivityForResult(Const.REQUEST_CHAT);
  }

  private void startChat(ChatContentType contentType, @Nullable String contentId, Transition transition) {
    if (contentType == ChatContentType.USER_CHAT && contentId != null) {
      ChatUtils.createChatActivityIntent(this)
          .putExtra(Const.EXTRA_CHAT_CONTENT_TYPE, contentType.toString())
          .putExtra(Const.EXTRA_CHAT_CONTENT_ID, contentId)
          .setTransition(transition)
          .startActivityForResult(Const.REQUEST_CHAT);
    }
  }

  private void showPermissionDeniedToast() {
    Toast.makeText(
        this,
        ResUtils.getString("ch.permission.denied"),
        Toast.LENGTH_LONG
    ).show();
  }

  private void setLoungeMediaErrorViewDescription(@Nullable View errorView, String type) {
    if (errorView instanceof LoungeMediaErrorCardView) {
      ((LoungeMediaErrorCardView) errorView).setLoungeMediaType(type);
    }
  }
}
