package com.zoyi.channel.plugin.android.activity.common.watermark;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.IntentUtils;

public class ChannelWatermarkView extends FrameLayout {

  private Context context;

  private View root;

  private boolean isActive = false;
  private boolean isVisible = false;

  public ChannelWatermarkView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChannelWatermarkView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    root = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_channel_watermark, this, true);
    root.setBackgroundColor(Color.TRANSPARENT);
    root.setOnClickListener(v -> {
      Channel channel = ChannelStore.get().channelState.get();

      if (channel != null) {
        IntentUtils.setUrl(
            ChannelWatermarkView.this.context, String.format(
                Const.UTM_URL,
                SettingsStore.get().language.get().toString(),
                Const.UTM_PATH_WATERMARK,
                channel.getName(),
                channel.getId()
            )
        ).startActivity();
      }
    });
  }

  public void setActivateState(boolean isActive) {
    if (this.isActive != isActive) {
      this.isActive = isActive;

      if (isActive) {
        animate(this.isVisible ? 1 : 0, 250);
      } else {
        animate(0, 0);
      }
    }
  }

  public void setOpacityState(boolean isVisible) {
    if (this.isVisible != isVisible) {
      this.isVisible = isVisible;

      if (this.isActive) {
        animate(isVisible ? 1 : 0, 250);
      }
    }
  }

  private void animate(float alpha, long duration) {
    animate().alpha(alpha).setDuration(duration).start();
  }
}
