package com.zoyi.channel.plugin.android.activity.chat2;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.model.SendFileItem;
import com.zoyi.channel.plugin.android.activity.chat.model.SendItem;
import com.zoyi.channel.plugin.android.contract.BaseAdapterPresenter;
import com.zoyi.channel.plugin.android.contract.BaseView;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.model.entity.ProfileEntity;
import com.zoyi.channel.plugin.android.model.rest.ActionButton;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.model.source.photopicker.PhotoItem;

import java.util.List;

public interface ChatContract2 {

  interface View extends BaseView {

    void onFetchStateChange(FetchState fetchState);

    void onChatStateChange(UserChat userChat);

    void onChatInteractionStateChange(ChatInteractionState inputType);

    boolean isScrollOnBottom();

    void scrollToBottom();

    boolean isScrollable();

    void switchHeader(boolean showAssignee);
  }

  interface Presenter extends BaseAdapterPresenter {

    void createMarketingSupportBotUserChat();

    void onActionClick(@NonNull String actionType, @NonNull ActionButton actionButton);

    void fetchPrevMessages();

    void deleteMessage(String messageId);

    void sendText(String message);

    void resend(SendItem item);

    void removeFailedItem(SendItem item);

    void uploadFiles(List<PhotoItem> photoItems);

    void cancelSendingFile(SendFileItem item);
  }
}
