package com.zoyi.channel.plugin.android.activity.chat.view.chat;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.ChatInteractionListener;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.util.io.Keyboard;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatInteractionView extends LinearLayout {

  private Context context;

  private View viewChatBlocked;

  private ChatStartButton buttonNewChat;
  private LinearLayout layoutInteractionContent;
  private View layoutChatInput;
  private View buttonAttach;
  private WatchedEditText editChat;
  private View buttonSend;
  private View buttonMarketingSupportBot;

  @Nullable
  private String userChatId;

  @Nullable
  private ChatInteractionListener chatInteractionListener;

  private ChatInteractionState chatInteractionState = ChatInteractionState.NONE;

  public ChatInteractionView(Context context) {
    super(context);
    init(context);
  }

  public ChatInteractionView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChatInteractionView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_chat_interaction, this, true);

    buttonNewChat = view.findViewById(R.id.ch_buttonChatInteractionStartNewChat);
    buttonNewChat.setOnClickListener(v -> {
      if (chatInteractionListener != null) {
        chatInteractionListener.startNewChat(Const.RESULT_CHAT_OPEN_NEW_CHAT, Transition.NONE);
      }
    });

    layoutInteractionContent = view.findViewById(R.id.ch_layoutChatInteractionContent);

    buttonMarketingSupportBot = view.findViewById(R.id.ch_buttonChatInteractionMarketingSupportBot);
    buttonMarketingSupportBot.setOnClickListener(v -> {
      if (chatInteractionListener != null) {
        chatInteractionListener.startMarketingSupportBot();
      }
    });

    viewChatBlocked = view.findViewById(R.id.ch_textChatInteractionBlocked);

    layoutChatInput = view.findViewById(R.id.ch_layoutChatInteractionInput);

    buttonAttach = view.findViewById(R.id.ch_buttonChatInteractionAttach);
    buttonAttach.setOnClickListener(v -> {
      if (chatInteractionListener != null) {
        chatInteractionListener.onAttachmentButtonClick();
      }
    });

    editChat = view.findViewById(R.id.ch_editChatInteraction);

    buttonSend = view.findViewById(R.id.ch_buttonChatInteractionSend);
    buttonSend.setEnabled(true);
    buttonSend.setOnClickListener(v -> {
      String newString = StringUtils.stripEnd(editChat.getString(), null);

      if (chatInteractionListener != null && !TextUtils.isEmpty(newString)) {
        chatInteractionListener.onSendClick(newString);
      }
      editChat.setText("");
    });

    editChat.setWatchedTextChangedListener(s -> {
      TypingStore.get().typingState.set(!TextUtils.isEmpty(s));

      if (TextUtils.isEmpty(s)) {
        TypingStore.get().myTypingState.remove(Typing.dummy());
      } else {
        TypingStore.get().myTypingState.upsert(Typing.dummy());
      }

      String newString = StringUtils.stripEnd(s, null);
      boolean isEnabled = !TextUtils.isEmpty(newString);

      if (isEnabled != buttonSend.isEnabled()) {
        buttonSend.setEnabled(isEnabled);
      }

      if (userChatId != null) {
        TypingTextSaveStore.get().savedTexts.upsert(new Pair<>(userChatId, s));
      }
    });

    editChat.setOnFocusChangeListener((v, hasFocus) -> {
      if (hasFocus) {
        setInputDim(false);
        ProfileBotStore.get().requestFocus.set(false);
      }
    });
  }

  public void initUserChat(String userChatId) {
    if (this.userChatId == null) {
      this.userChatId = userChatId;

      Pair<String, String> pair = TypingTextSaveStore.get().savedTexts.get(userChatId);

      if (pair != null && pair.second != null) {
        editChat.setText(pair.second);
      }
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    TypingStore.get().typingState.set(false);
  }

  public void setChatInteractionListener(@Nullable ChatInteractionListener chatInteractionListener) {
    this.chatInteractionListener = chatInteractionListener;
  }

  public void setInputDim(boolean enabled) {
    layoutChatInput.setBackgroundColor(
        ResUtils.getColor(enabled ? R.color.ch_grey200 : R.color.ch_white)
    );
  }

  public void setState(ChatInteractionState chatInteractionState) {
    if (this.chatInteractionState != chatInteractionState) {
      this.chatInteractionState = chatInteractionState;

      Views.setVisibility(buttonNewChat, false);
      Views.setVisibility(layoutInteractionContent, false);
      Views.setVisibility(buttonMarketingSupportBot, false);
      Views.setVisibility(viewChatBlocked, false);
      Views.setVisibility(layoutChatInput, false);

      switch (chatInteractionState) {
        case NORMAL:
          Views.setVisibility(layoutInteractionContent, true);
          Views.setVisibility(layoutChatInput, true);
          break;

        case MARKETING_SUPPORT_BOT:
          Keyboard.close(context, editChat);

          Views.setVisibility(layoutInteractionContent, true);
          Views.setVisibility(buttonMarketingSupportBot, true);
          break;

        case DISABLE:
          Keyboard.close(context, editChat);

          Views.setVisibility(layoutInteractionContent, true);
          Views.setVisibility(viewChatBlocked, true);
          break;

        case NEW_CHAT_START:
          Keyboard.close(context, editChat);

          Views.setVisibility(buttonNewChat, true);
          break;

        case NONE:
          Keyboard.close(context, editChat);
          break;
      }
    }
  }

  public void setFocus() {
    editChat.requestFocus();
  }
}
