package com.zoyi.channel.plugin.android.activity.chat.view.chat;

import android.content.Context;
import android.support.annotation.Nullable;
import android.support.v4.util.Pair;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.EditText;
import android.widget.LinearLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.chat.listener.MessageActionListener;
import com.zoyi.channel.plugin.android.enumerate.ChatInteractionState;
import com.zoyi.channel.plugin.android.model.etc.Typing;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class ChatInputView extends LinearLayout {

  private Context context;

  private View viewChatBlocked;

  private View layoutChatInput;
  private View buttonAttach;
  private WatchedEditText editChat;
  private View buttonSend;
  private View buttonStartSupportBot;

  @Nullable
  private String userChatId;

  @Nullable
  private MessageActionListener messageActionListener;

  public ChatInputView(Context context) {
    super(context);
    init(context);
  }

  public ChatInputView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public ChatInputView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    this.context = context;

    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_chat_input, this, true);

    buttonStartSupportBot = view.findViewById(R.id.ch_buttonStartSupportBot);

    viewChatBlocked = view.findViewById(R.id.ch_textChatBlocked);

    layoutChatInput = view.findViewById(R.id.ch_layoutChatInput);
    buttonAttach = view.findViewById(R.id.ch_buttonChatAttach);
    buttonAttach.setOnClickListener(v -> {
      if (messageActionListener != null) {
        messageActionListener.onAttachmentButtonClick();
      }
    });

    editChat = view.findViewById(R.id.ch_editChat);

    buttonSend = view.findViewById(R.id.buttonChatSend);
    buttonSend.setEnabled(true);
    buttonSend.setOnClickListener(v -> {
      String newString = StringUtils.stripEnd(editChat.getString(), null);

      if (messageActionListener != null && !TextUtils.isEmpty(newString)) {
        messageActionListener.onSendClick(newString);
      }
      editChat.setText("");
    });

    editChat.setWatchedTextChangedListener(s -> {
      TypingStore.get().typingState.set(!TextUtils.isEmpty(s));

      if (TextUtils.isEmpty(s)) {
        TypingStore.get().myTypingState.remove(Typing.dummy());
      } else {
        TypingStore.get().myTypingState.upsert(Typing.dummy());
      }

      String newString = StringUtils.stripEnd(s, null);
      boolean isEnabled = !TextUtils.isEmpty(newString);

      if (isEnabled != buttonSend.isEnabled()) {
        buttonSend.setEnabled(isEnabled);
      }

      if (userChatId != null) {
        TypingTextSaveStore.get().savedTexts.upsert(new Pair<>(userChatId, s));
      }
    });

    editChat.setOnFocusChangeListener((v, hasFocus) -> {
      if (hasFocus) {
        setInputDim(false);
        ProfileBotStore.get().requestFocus.set(false);
      }
    });
  }

  public void initUserChat(String userChatId) {
    if (this.userChatId == null) {
      this.userChatId = userChatId;

      Pair<String, String> pair = TypingTextSaveStore.get().savedTexts.get(userChatId);

      if (pair != null && pair.second != null) {
        editChat.setText(pair.second);
      }
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    TypingStore.get().typingState.set(false);
  }

  public void setMessageActionListener(@Nullable MessageActionListener messageActionListener) {
    this.messageActionListener = messageActionListener;
  }

  public void setInputDim(boolean enabled) {
    layoutChatInput.setBackgroundColor(
        ResUtils.getColor(enabled ? R.color.ch_grey200 : R.color.ch_white)
    );
  }

  public EditText getEditText() {
    return editChat;
  }

  public void setState(ChatInteractionState chatInteractionState) {
    switch (chatInteractionState) {
      case MARKETING_SUPPORT_BOT:
        buttonStartSupportBot.setVisibility(View.VISIBLE);
        viewChatBlocked.setVisibility(View.GONE);
        layoutChatInput.setVisibility(View.GONE);
        break;
      case DISABLE:
        buttonStartSupportBot.setVisibility(View.GONE);
        viewChatBlocked.setVisibility(View.VISIBLE);
        layoutChatInput.setVisibility(View.GONE);
        break;
      default:
        buttonStartSupportBot.setVisibility(View.GONE);
        viewChatBlocked.setVisibility(View.GONE);
        layoutChatInput.setVisibility(View.VISIBLE);
        break;
    }
  }

  public void setFocus() {
    editChat.requestFocus();
  }

  public void setStartSupportBotClickListener(OnClickListener startSupportBotClickListener) {
    this.buttonStartSupportBot.setOnClickListener(startSupportBotClickListener);
  }
}
