package com.zoyi.channel.plugin.android.activity.chat.model;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.model.rest.*;

import java.util.List;

/**
 * Created by mika on 2018. 10. 26..
 */

public class SupportBotMessageItem extends InitMessageItem {

  @NonNull
  private SupportBotEntry supportBotEntry;

  public SupportBotMessageItem(@NonNull SupportBotEntry supportBotEntry) {
    super(supportBotEntry.getBot());

    this.supportBotEntry = supportBotEntry;
  }

  @Nullable
  public List<ActionButton> getButtons() {
    return supportBotEntry.getButtons();
  }

  @Nullable
  public List<Block> getBlocks() {
    return supportBotEntry.getBlocks();
  }

  @Nullable
  public List<File> getFiles() {
    return supportBotEntry.getFiles();
  }

  @Nullable
  public WebPage getWebPage() {
    return supportBotEntry.getWebPage();
  }

  @Nullable
  public List<Button> getLinkButtons() {
    return supportBotEntry.getLinkButtons();
  }

  @Override
  public String getSecondaryKey() {
    return "SupportBotMessageItem";
  }

  @Override
  public MessageType getType() {
    return MessageType.SUPPORT_BOT;
  }

  public String getId() {
    return supportBotEntry.getId();
  }
}
