package com.zoyi.channel.plugin.android.activity.chat.binder;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.bind.*;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.store.binder.Binder2;
import com.zoyi.channel.plugin.android.store.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action1;

public class ChatHeaderBinder extends Binder {
  @Nullable
  private UserChat userChat;

  private StoreBinder binder;

  public ChatHeaderBinder(Action1<Boolean> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;

    this.binder = new Binder2<>(channelState, nowState).bind(
        (channel, now) -> {
          if (this.userChat != null && this.userChat.getAssigneeId() != null && ChannelUtils.isWorking(channel, now)) {
            action1.call(this.userChat != null && this.userChat.getAssigneeId() != null && ChannelUtils.isWorking(channel, now));
          }
        });
  }

  public void setUserChat(@Nullable UserChat userChat) {
    this.userChat = userChat;

    this.binder.revoke();
  }

  @Override
  public void unbind() {
    this.binder.unbind();
  }

  @Override
  public ChatHeaderBinder bind(BinderController controller) {
    super.bind(controller);

    return this;
  }
}
