/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat2;

import android.app.Activity;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.activity.chat.contract.ChatAdapterContract;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.model.WelcomeMessageItem;
import com.zoyi.channel.plugin.android.activity.chat2.ChatContract2;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.base.AbstractAdapterPresenter;
import com.zoyi.channel.plugin.android.bind.BindAction;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener;
import com.zoyi.channel.plugin.android.open.option.Language;
import com.zoyi.channel.plugin.android.selector.ChatSelector;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.PluginStore;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.rx.functions.Action5;

public class ChatPresenter2
extends AbstractAdapterPresenter<ChatContract2.View, ChatAdapterContract.View, ChatAdapterContract.Model>
implements ChatContract2.Presenter {
    private ChatContentType contentType = ChatContentType.NONE;
    @Nullable
    private String contentId;
    @Nullable
    private String presetMessage;

    public ChatPresenter2(ChatContract2.View view, ChatAdapterContract.View adapterView, ChatAdapterContract.Model adapterModel, @Nullable String contentId, @Nullable String presetMessage) {
        super(view, adapterView, adapterModel);
        this.contentId = contentId;
        this.presetMessage = presetMessage;
    }

    @Override
    public void init() {
        ((ChatContract2.View)this.view).onFetchStateChange(FetchState.LOADING);
        if (this.contentId != null) {
            this.contentType = ChatContentType.USER_CHAT;
            this.bindUserChat();
        } else {
            Plugin plugin = PluginStore.get().pluginState.get();
            if (plugin != null && plugin.getId() != null) {
                this.setLocalChat();
            }
        }
    }

    private void setLocalChat() {
        Plugin plugin = PluginStore.get().pluginState.get();
        FetchState pluginFetch = (FetchState)((Object)PluginStore.get().pluginFetchState.get());
        SupportBotEntry supportBotEntry = SupportBotStore.get().supportBotState.get();
        FetchState supportBotFetch = (FetchState)((Object)SupportBotStore.get().supportBotFetchState.get());
        Language language = (Language)((Object)SettingsStore.get().language.get());
        CharSequence welcomeMessage = MessageUtils.createWelcomeMessage(plugin, language);
        if (this.presetMessage != null) {
            this.setLocalMessage(welcomeMessage, null);
        } else if (supportBotFetch == FetchState.COMPLETE && supportBotEntry != null) {
            this.setLocalMessage(null, supportBotEntry);
        } else if (pluginFetch == FetchState.COMPLETE && plugin != null) {
            this.setLocalMessage(welcomeMessage, null);
        } else {
            ((ChatContract2.View)this.view).finish();
        }
    }

    private void setLocalMessage(@Nullable CharSequence welcomeMessage, @Nullable SupportBotEntry supportBotEntry) {
        if (welcomeMessage != null) {
            this.contentType = ChatContentType.NONE;
            ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new WelcomeMessageItem(welcomeMessage));
            ((ChatContract2.View)this.view).onLocalMessageLoaded(ChatContentType.NONE, false);
            ((ChatContract2.View)this.view).onFetchStateChange(FetchState.COMPLETE);
        } else if (supportBotEntry != null) {
            this.contentType = ChatContentType.SUPPORT_BOT_CHAT;
            this.contentId = supportBotEntry.getId();
            ((ChatAdapterContract.Model)this.adapterModel).setInitMessage(new SupportBotMessageItem(supportBotEntry));
            ((ChatContract2.View)this.view).onLocalMessageLoaded(ChatContentType.SUPPORT_BOT_CHAT, false);
            ((ChatContract2.View)this.view).onFetchStateChange(FetchState.COMPLETE);
        }
    }

    @Override
    public void createUserChat() {
        if (!Api.isRunning(ActionType.CREATE_USER_CHAT)) {
            Plugin plugin = PluginStore.get().pluginState.get();
            String pluginId = plugin != null ? plugin.getId() : null;
            Activity topActivity = GlobalStore.get().topActivity.get();
            String url = (String)Optional.ofNullable((Object)topActivity).map(Object::getClass).map(Class::getSimpleName).orElse((Object)"");
            if (pluginId != null) {
                Api.createUserChat2(pluginId, url).onError(error -> ((ChatContract2.View)this.view).onFetchStateChange(FetchState.FAILED)).call(repo -> {
                    ChannelPluginListener listener = ChannelIO.getListener();
                    if (listener != null && repo.getUserChat().getId() != null) {
                        listener.onChatCreated(repo.getUserChat().getId());
                    }
                    this.handleUserChatInit(repo.getUserChat(), repo.getMessage());
                }).bind(this, BindAction.CREATE_CHAT);
            }
        }
    }

    private void handleUserChatInit(UserChat userChat, Message message) {
        this.clear();
        if (userChat != null && userChat.getId() != null) {
            this.contentType = ChatContentType.USER_CHAT;
            this.contentId = userChat.getId();
            ((ChatAdapterContract.Model)this.adapterModel).replaceInitMessageItem(message);
            this.bindUserChat();
        }
    }

    private void bindUserChat() {
        if (this.contentType == ChatContentType.USER_CHAT && this.contentId != null) {
            this.bind(ChatSelector.bindChat(this.contentId, (Action5<UserChat, Message, Boolean, Boolean, Boolean>)((Action5)(userChat, recentMessage, acceptInput, temporaryInputOpened, isWorking) -> ((ChatContract2.View)this.view).onChatStateChange((UserChat)userChat, (Message)recentMessage, (boolean)acceptInput, (boolean)temporaryInputOpened, (boolean)isWorking))));
        }
    }
}

