/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat2;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.view.navigation.HostHeaderView;
import com.zoyi.channel.plugin.android.activity.chat2.ChatContract2;
import com.zoyi.channel.plugin.android.activity.chat2.ChatPresenter2;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.navigation.ChannelInfoNavigationView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.enumerate.Transition;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.load_wrapper.LoadWrapperLayout;
import com.zoyi.com.annimon.stream.Optional;

public class ChatActivity2
extends BaseActivity2
implements ChatContract2.View {
    private NavigationView navigation;
    private ChannelInfoNavigationView channelHeader;
    private HostHeaderView hostHeader;
    private LoadWrapperLayout loaderChat;
    private ChatStartButton buttonNewChat;
    private ChatAdapter adapter;
    private ChatContract2.Presenter presenter;

    @Override
    @Initializer
    protected boolean onCreate() {
        this.init(R.layout.ch_plugin_activity_chat2);
        String contentId = (String)Optional.ofNullable((Object)this.getIntent()).map(intent -> intent.getStringExtra("chatContentId")).orElse(null);
        String presetMessage = (String)Optional.ofNullable((Object)this.getIntent()).map(intent -> intent.getStringExtra("chatPresetMessage")).orElse(null);
        this.navigation = (NavigationView)this.findViewById(R.id.ch_navigationChat);
        this.navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));
        this.channelHeader = (ChannelInfoNavigationView)this.findViewById(R.id.ch_navigationChatChannel);
        this.hostHeader = (HostHeaderView)this.findViewById(R.id.ch_navigationChatHost);
        this.hostHeader.setVisibility(8);
        this.loaderChat = (LoadWrapperLayout)this.findViewById(R.id.ch_loaderChat);
        this.adapter = new ChatAdapter(null);
        this.adapter.setOnMessageContentClickListener(null);
        this.adapter.setOnProfileUpdateRequestListener(null);
        this.presenter = new ChatPresenter2(this, this.adapter, this.adapter, contentId, presetMessage);
        this.buttonNewChat = (ChatStartButton)this.findViewById(R.id.ch_buttonChatStartNewChat);
        this.buttonNewChat.setOnClickListener(v -> {
            if (this.presenter != null) {
                this.presenter.createUserChat();
            }
        });
        this.bindPresenter(this.presenter);
        return true;
    }

    @Override
    public void onFetchStateChange(FetchState fetchState) {
        this.loaderChat.setLoadState(fetchState);
    }

    @Override
    public void onLocalMessageLoaded(ChatContentType contentType, boolean acceptInput) {
        this.channelHeader.setVisibility(0);
        this.hostHeader.setVisibility(8);
        this.buttonNewChat.setVisibility(0);
    }

    @Override
    public void onChatStateChange(UserChat userChat, Message recentMessage, boolean acceptInput, boolean temporaryInputOpened, boolean isWorking) {
        if (userChat.isStateRemoved()) {
            this.finish(Transition.NONE);
            return;
        }
        if (userChat.getAssigneeId() != null && isWorking) {
            this.channelHeader.setVisibility(8);
            this.hostHeader.setVisibility(0);
            this.hostHeader.attachUserChat(userChat.getId());
        } else {
            this.channelHeader.setVisibility(0);
            this.hostHeader.setVisibility(8);
        }
        if (recentMessage != null && recentMessage.getMarketing() != null && recentMessage.getMarketing().getEnableSupportBot() && userChat.getState() == null && !userChat.isSupporting() && SupportBotStore.get().supportBotState.get() != null) {
            this.buttonNewChat.setVisibility(8);
        } else if (userChat.isSupporting()) {
            this.buttonNewChat.setVisibility(8);
        } else if (userChat.isStateClosed()) {
            this.buttonNewChat.setVisibility(0);
        } else if (userChat.isStateSolved()) {
            if (temporaryInputOpened) {
                this.buttonNewChat.setVisibility(8);
            } else {
                this.buttonNewChat.setVisibility(8);
            }
        } else {
            this.buttonNewChat.setVisibility(8);
        }
    }
}

