/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.enumerate.SocketStatus;
import com.zoyi.channel.plugin.android.model.etc.PushEvent;
import com.zoyi.channel.plugin.android.open.model.PopupData;
import com.zoyi.channel.plugin.android.selector.GlobalSelector;
import com.zoyi.channel.plugin.android.selector.SocketSelector;
import com.zoyi.channel.plugin.android.selector.UserSelector;
import com.zoyi.rx.functions.Action1;

public class ChannelActionHandler {
    @Nullable
    private com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener;
    @Nullable
    private ChannelPluginListener legacyListener;
    @Nullable
    private Binder socketBinder;
    @Nullable
    private Binder countHandler;
    @Nullable
    private Binder popupHandler;
    @Nullable
    private Binder legacyInAppPushHandler;
    @Nullable
    private Binder messengerVisibilityBinder;

    public void handle() {
        this.messengerVisibilityBinder = GlobalSelector.bindMessengerVisibility((Action1<Boolean>)((Action1)visible -> {
            if (this.listener != null) {
                if (visible.booleanValue()) {
                    this.listener.onShowMessenger();
                } else {
                    this.listener.onHideMessenger();
                }
            }
            if (this.legacyListener != null) {
                if (visible.booleanValue()) {
                    this.legacyListener.willShowMessenger();
                } else {
                    this.legacyListener.willHideMessenger();
                }
            }
        }));
        this.socketBinder = SocketSelector.bindSocket((Action1<SocketStatus>)((Action1)socketStatus -> {
            if (socketStatus == SocketStatus.READY) {
                UserAction.touch();
            }
        }));
        this.countHandler = UserSelector.bindUserAlertCount((Action1<Integer>)((Action1)count -> {
            if (this.listener != null && count != null) {
                this.listener.onBadgeChanged((int)count);
            }
            if (this.legacyListener != null && count != null) {
                this.legacyListener.onChangeBadge((int)count);
            }
        }));
        this.popupHandler = GlobalSelector.bindPopup((Action1<PopupData>)((Action1)popupData -> {
            if (this.listener != null && popupData != null) {
                this.listener.onPopupDataReceived((PopupData)popupData);
            }
        }));
        this.legacyInAppPushHandler = GlobalSelector.bindLegacyInAppPush((Action1<PushEvent>)((Action1)pushEvent -> {
            if (this.legacyListener != null && pushEvent != null) {
                this.legacyListener.onReceivePush((PushEvent)pushEvent);
            }
        }));
    }

    public void unHandle() {
        if (this.messengerVisibilityBinder != null) {
            this.messengerVisibilityBinder.unbind();
            this.messengerVisibilityBinder = null;
        }
        if (this.socketBinder != null) {
            this.socketBinder.unbind();
            this.socketBinder = null;
        }
        if (this.countHandler != null) {
            this.countHandler.unbind();
            this.countHandler = null;
        }
        if (this.legacyInAppPushHandler != null) {
            this.legacyInAppPushHandler.unbind();
            this.legacyInAppPushHandler = null;
        }
        if (this.popupHandler != null) {
            this.popupHandler.unbind();
            this.popupHandler = null;
        }
    }

    @Nullable
    public com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener getListener() {
        return this.listener;
    }

    public void setListener(@Nullable com.zoyi.channel.plugin.android.open.listener.ChannelPluginListener listener) {
        this.listener = listener;
    }

    @Nullable
    public ChannelPluginListener getLegacyListener() {
        return this.legacyListener;
    }

    public void setLegacyListener(@Nullable ChannelPluginListener listener) {
        this.legacyListener = listener;
    }

    public void clearListener() {
        this.listener = null;
        this.legacyListener = null;
    }
}

