package com.zoyi.channel.plugin.android.glide;

import android.content.Context;
import android.os.Build;

import com.zoyi.channel.plugin.android.network.RetrofitInterceptor;
import com.zoyi.channel.plugin.android.network.TLSSocketFactory;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.GlideBuilder;
import com.zoyi.com.bumptech.glide.load.model.GlideUrl;
import com.zoyi.com.bumptech.glide.module.GlideModule;
import com.zoyi.okhttp3.OkHttpClient;

import java.io.InputStream;
import java.util.concurrent.TimeUnit;

/**
 * Created by mika on 2018. 11. 30..
 */

public class ChannelPluginGlideModule implements GlideModule {

  @Override
  public void applyOptions(Context context, GlideBuilder glideBuilder) {
  }

  @Override
  public void registerComponents(Context context, Glide glide) {
    try {
      OkHttpClient.Builder builder = new OkHttpClient.Builder()
          .addInterceptor(new RetrofitInterceptor())
          .connectTimeout(45, TimeUnit.SECONDS)
          .readTimeout(45, TimeUnit.SECONDS)
          .writeTimeout(45, TimeUnit.SECONDS);

      if (Build.VERSION.SDK_INT < Build.VERSION_CODES.LOLLIPOP) {
        TLSSocketFactory socketFactory = new TLSSocketFactory();
        builder.socketFactory(socketFactory);
      }

      glide.register(GlideUrl.class, InputStream.class, new OkHttpUrlLoader.Factory(builder.build()));

    } catch (Exception e) {
      e.printStackTrace();
    }

  }
}
