package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Manager;
import com.zoyi.channel.plugin.android.selector.ManagerSelector;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.channel.plugin.android.view.layout.AvatarLayout;

import java.util.List;

public class FollowingManagersView extends FrameLayout {

  private AvatarLayout avatar1;
  private AvatarLayout avatar2;
  private AvatarLayout avatar3;
  private AvatarLayout avatar4;
  private ImageView outOfWorking;

  @Nullable
  private Binder binder;

  public FollowingManagersView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public FollowingManagersView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public FollowingManagersView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  @Initializer
  private void init(Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_following_managers, this, true);

    avatar1 = view.findViewById(R.id.ch_avatarFollowingManagers1);
    avatar2 = view.findViewById(R.id.ch_avatarFollowingManagers2);
    avatar3 = view.findViewById(R.id.ch_avatarFollowingManagers3);
    avatar4 = view.findViewById(R.id.ch_avatarFollowingManagers4);
    outOfWorking = view.findViewById(R.id.ch_imageFollowingManagersOutOfWorking);
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = ManagerSelector.bindFollowingManagers((managers, isWorking) -> {
      if (isWorking != null && !isWorking) {
        setOutOfWorking();
      } else if (managers != null) {
        setAvatarLayouts(managers);
      } else {
        hideLayout();
      }
    });
  }

  private void setAvatarLayouts(List<Manager> managers) {
    avatar1.setVisibility(View.GONE);
    avatar2.setVisibility(View.GONE);
    avatar3.setVisibility(View.GONE);
    avatar4.setVisibility(View.GONE);
    outOfWorking.setVisibility(View.GONE);

    switch (managers.size()) {
      case 0: break;

      case 1:
        setAvatar(avatar1, 60, 0, 0, managers.get(0));
        break;

      case 2:
        setAvatar(avatar1, 48, 0, 0, managers.get(0));
        setAvatar(avatar2, 48, 0, 50, managers.get(1));
        break;

      case 3:
        setAvatar(avatar1, 40, 0, 22, managers.get(0));
        setAvatar(avatar2, 40, 36, 0, managers.get(1));
        setAvatar(avatar3, 40, 36, 42, managers.get(2));
        break;

      default:
        setAvatar(avatar1, 36, 0, 0, managers.get(0));
        setAvatar(avatar2, 36, 0, 38, managers.get(1));
        setAvatar(avatar3, 36, 38, 0, managers.get(2));
        setAvatar(avatar4, 36, 38, 38, managers.get(3));
        break;
    }
  }

  private void setAvatar(AvatarLayout avatar, int sizeDp, int topMarginDp, int leftMarginDp, Manager manager) {
    avatar.setVisibility(View.VISIBLE);

    LayoutParams layoutParams = (LayoutParams) avatar.getLayoutParams();

    layoutParams.width = (int) Utils.dpToPx(sizeDp);
    layoutParams.height = (int) Utils.dpToPx(sizeDp);
    layoutParams.setMargins((int) Utils.dpToPx(leftMarginDp), (int) Utils.dpToPx(topMarginDp), 0, 0);

    avatar.setLayoutParams(layoutParams);

    avatar.set(manager);
  }

  private void setOutOfWorking() {
    avatar1.setVisibility(View.GONE);
    avatar2.setVisibility(View.GONE);
    avatar3.setVisibility(View.GONE);
    avatar4.setVisibility(View.GONE);
    outOfWorking.setVisibility(View.VISIBLE);
  }

  private void hideLayout() {
    avatar1.setVisibility(View.GONE);
    avatar2.setVisibility(View.GONE);
    avatar3.setVisibility(View.GONE);
    avatar4.setVisibility(View.GONE);
    outOfWorking.setVisibility(View.GONE);
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
      binder = null;
    }
  }
}
