package com.zoyi.channel.plugin.android.activity.chat2;

import android.content.Intent;
import android.view.View;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.ChatAdapter;
import com.zoyi.channel.plugin.android.activity.chat.view.navigation.HostHeaderView;
import com.zoyi.channel.plugin.android.activity.common.chat.ChatContentType;
import com.zoyi.channel.plugin.android.activity.common.error.ErrorRefreshView;
import com.zoyi.channel.plugin.android.activity.common.navigation.ChannelInfoNavigationView;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.enumerate.*;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store.SupportBotStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.view.button.ChatStartButton;
import com.zoyi.channel.plugin.android.view.load_wrapper.LoadWrapperLayout;
import com.zoyi.com.annimon.stream.Optional;

public class ChatActivity2
    extends BaseActivity2
    implements
    ChatContract2.View{

  private NavigationView navigation;
  private ChannelInfoNavigationView channelHeader;
  private HostHeaderView hostHeader;

  private LoadWrapperLayout loaderChat;

  private ChatStartButton buttonNewChat;

  private ChatAdapter adapter;

  private ChatContract2.Presenter presenter;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_chat2);

    String contentId = Optional.ofNullable(getIntent()).map(intent -> intent.getStringExtra(Const.EXTRA_CHAT_CONTENT_ID)).orElse(null);
    String presetMessage = Optional.ofNullable(getIntent()).map(intent -> intent.getStringExtra(Const.EXTRA_CHAT_PRESET_MESSAGE)).orElse(null);

    // view initialize

    navigation = findViewById(R.id.ch_navigationChat);
    navigation.addAction(R.drawable.ch_plugin_close_white, v -> Action.invoke(ActionType.EXIT));

    channelHeader = findViewById(R.id.ch_navigationChatChannel);
    hostHeader = findViewById(R.id.ch_navigationChatHost);
    hostHeader.setVisibility(View.GONE);

    loaderChat = findViewById(R.id.ch_loaderChat);

    // adapter initialize

    adapter = new ChatAdapter(null);
    adapter.setOnMessageContentClickListener(null);
    adapter.setOnProfileUpdateRequestListener(null);

    // presenter initialize

    presenter = new ChatPresenter2(
        this,
        adapter,
        adapter,
        contentId,
        presetMessage
    );

    // TODO : Fix start new chat, this is temporal logic for test
    buttonNewChat = findViewById(R.id.ch_buttonChatStartNewChat);
    buttonNewChat.setOnClickListener(v -> {
      if (presenter != null) {
        presenter.createUserChat();
      }
    });

    bindPresenter(presenter);

    return true;
  }

  @Override
  public void onFetchStateChange(FetchState fetchState) {
    loaderChat.setLoadState(fetchState);
  }

  @Override
  public void onLocalMessageLoaded(ChatContentType contentType, boolean acceptInput) {
    channelHeader.setVisibility(View.VISIBLE);
    hostHeader.setVisibility(View.GONE);

    // input & bottom placeholder
    // input view should set visibility case by case to keep focus

    buttonNewChat.setVisibility(View.VISIBLE);

    // TODO : add input logic
  }

  @Override
  public void onChatStateChange(
      UserChat userChat,
      Message recentMessage,
      boolean acceptInput,
      boolean temporaryInputOpened,
      boolean isWorking
  ) {
    if (userChat.isStateRemoved()) {
      finish(Transition.NONE);
      return;
    }

    // TODO : add input logic

    // navigation

    if (userChat.getAssigneeId() != null && isWorking) {
      channelHeader.setVisibility(View.GONE);
      hostHeader.setVisibility(View.VISIBLE);
      hostHeader.attachUserChat(userChat.getId());
    } else {
      channelHeader.setVisibility(View.VISIBLE);
      hostHeader.setVisibility(View.GONE);
    }

    // input & bottom placeholder
    // input view should set visibility case by case to keep focus

    if (recentMessage != null
        && recentMessage.getMarketing() != null
        && recentMessage.getMarketing().getEnableSupportBot()
        && userChat.getState() == null
        && !userChat.isSupporting()
        && SupportBotStore.get().supportBotState.get() != null) {
      buttonNewChat.setVisibility(View.GONE);
    } else if (userChat.isSupporting()) {
      buttonNewChat.setVisibility(View.GONE);
    } else if (userChat.isStateClosed()) {
      buttonNewChat.setVisibility(View.VISIBLE);
    } else if (userChat.isStateSolved()) {
      if (temporaryInputOpened) {
        buttonNewChat.setVisibility(View.GONE);
      } else {
        buttonNewChat.setVisibility(View.GONE);
      }
    } else {
      buttonNewChat.setVisibility(View.GONE);
    }
  }
}
