/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.network;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.repo.BaseRepo;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Subscriber;

public class RestSubscriber<E>
extends Subscriber<E> {
    @Nullable
    private ActionType actionType;
    @Nullable
    private ActionType[] cancelTypes;

    public void setActionSubscription(@Nullable ActionType actionType, ActionType ... cancelTypes) {
        this.actionType = actionType;
        this.cancelTypes = cancelTypes;
    }

    public void onCompleted() {
    }

    public void onError(Throwable e) {
        try {
            RetrofitException retrofitException = RetrofitException.createException(e);
            L.e("Rest onError : " + retrofitException.getMessage());
            retrofitException.printStackTrace();
            this.onError(retrofitException);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Action.removeSubscriber(this);
    }

    public void onError(RetrofitException error) {
    }

    public void onNext(E e) {
        if (e != null) {
            if (e instanceof BaseRepo) {
                ((BaseRepo)e).update();
            }
            this.onSuccess(e);
        } else {
            this.onSuccessWithNull();
        }
        Action.removeSubscriber(this);
    }

    public void onSuccessWithNull() {
    }

    public void onSuccess(@NonNull E e) {
    }

    @Nullable
    public ActionType getActionType() {
        return this.actionType;
    }

    @NonNull
    public ActionType[] getCancelTypes() {
        if (this.cancelTypes != null) {
            return this.cancelTypes;
        }
        return new ActionType[0];
    }
}

