/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.download;

import android.annotation.TargetApi;
import android.app.Activity;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.net.Uri;
import android.os.Build;
import android.os.Environment;
import android.os.ParcelFileDescriptor;
import android.provider.MediaStore;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.RequiresApi;
import com.zoyi.channel.plugin.android.activity.download.DownloadContract;
import com.zoyi.channel.plugin.android.base.AbstractPresenter;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.network.DownloadApi;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.network.RetrofitInterceptor;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.util.Executor;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.RandomUtils;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.okhttp3.Interceptor;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.OkHttpClient;
import com.zoyi.okhttp3.Response;
import com.zoyi.okhttp3.ResponseBody;
import com.zoyi.okio.Buffer;
import com.zoyi.okio.BufferedSink;
import com.zoyi.okio.BufferedSource;
import com.zoyi.okio.ForwardingSource;
import com.zoyi.okio.Okio;
import com.zoyi.okio.Sink;
import com.zoyi.okio.Source;
import com.zoyi.retrofit2.CallAdapter;
import com.zoyi.retrofit2.Retrofit;
import com.zoyi.retrofit2.adapter.rxjava.RxJavaCallAdapterFactory;
import com.zoyi.rx.Subscription;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;

public class DownloadPresenter
extends AbstractPresenter<DownloadContract.View>
implements DownloadContract.Presenter {
    private Activity activity;
    private DownloadContract.View view;
    @Nullable
    private Subscription downloadSubscription;

    public DownloadPresenter(DownloadContract.View view, Activity activity) {
        super(view);
        this.activity = activity;
        this.view = view;
    }

    @Override
    public void init() {
    }

    @Override
    public void download(String url, final String filename, final @Nullable String type) {
        if (!this.createDirectory(type)) {
            this.view.onError(ResUtils.getString("ch.common_error"));
            return;
        }
        OkHttpClient client = new OkHttpClient.Builder().addInterceptor((Interceptor)new RetrofitInterceptor()).addNetworkInterceptor(chain -> {
            Response originResponse = chain.proceed(chain.request());
            if (originResponse.body() != null) {
                return originResponse.newBuilder().body((ResponseBody)new ProgressResponseBody(originResponse.body())).build();
            }
            return originResponse;
        }).build();
        DownloadApi api = (DownloadApi)new Retrofit.Builder().baseUrl(ServiceFactory.getRestEndPoint()).client(client).addCallAdapterFactory((CallAdapter.Factory)RxJavaCallAdapterFactory.create()).build().create(DownloadApi.class);
        this.downloadSubscription = new Api<Uri>(api.download(url).map(body -> this.handleDownload(this.activity, filename, type, (ResponseBody)body))).run(new RestSubscriber<Uri>(){

            @Override
            public void onError(RetrofitException error) {
                DownloadPresenter.this.view.onError(error.getMessage());
            }

            @Override
            public void onSuccess(@NonNull Uri uri) {
                DownloadPresenter.this.view.onDownloadComplete(uri, filename, !"image".equals(type) && !"video".equals(type));
            }

            @Override
            public void onSuccessWithNull() {
                DownloadPresenter.this.view.onError(ResUtils.getString("ch.common_error"));
            }
        });
    }

    @Nullable
    private Uri handleDownload(Activity activity, String filename, @Nullable String type, ResponseBody body) {
        if (Build.VERSION.SDK_INT >= 29) {
            return this.applyDownloadFrom29(activity, filename, type, body);
        }
        return this.applyDownloadUntil29(activity, filename, body, this.getDownloadRootPath(type));
    }

    @RequiresApi(value=29)
    @Nullable
    private Uri applyDownloadFrom29(Activity activity, String filename, @Nullable String type, ResponseBody body) {
        ContentResolver contentResolver = activity.getContentResolver();
        String relativePath = this.getDownloadRootPath(type) + File.separator + "ChannelPlugin";
        ContentValues values = this.getValues(filename, type, body, relativePath);
        Uri uri = this.getUri(contentResolver, type, values);
        String pendingKey = this.getPendingKey(type);
        if (uri != null) {
            try {
                ParcelFileDescriptor descriptor = contentResolver.openFileDescriptor(uri, "w", null);
                if (descriptor != null) {
                    FileOutputStream fos = new FileOutputStream(descriptor.getFileDescriptor());
                    fos.write(body.bytes());
                    fos.close();
                    descriptor.close();
                }
                contentResolver.update(uri, values, null, null);
                values.clear();
                values.put(pendingKey, Integer.valueOf(0));
                contentResolver.update(uri, values, null, null);
                return uri;
            }
            catch (Exception ex) {
                L.e(ex.getMessage());
            }
        }
        return null;
    }

    @RequiresApi(value=29)
    private ContentValues getValues(String filename, @Nullable String type, ResponseBody body, String relativePath) {
        ContentValues contentValues = new ContentValues();
        MediaType contentType = body.contentType();
        String contentTypeString = contentType != null ? contentType.toString() : "";
        switch (type != null ? type : "") {
            case "image": {
                contentValues.put("_display_name", filename);
                contentValues.put("mime_type", contentTypeString);
                contentValues.put("is_pending", Integer.valueOf(1));
                contentValues.put("relative_path", relativePath);
                break;
            }
            case "video": {
                contentValues.put("_display_name", filename);
                contentValues.put("mime_type", contentTypeString);
                contentValues.put("is_pending", Integer.valueOf(1));
                contentValues.put("relative_path", relativePath);
                break;
            }
            default: {
                contentValues.put("_display_name", filename);
                contentValues.put("mime_type", FileUtils.getMimeType(filename));
                contentValues.put("is_pending", Integer.valueOf(1));
                contentValues.put("relative_path", relativePath);
            }
        }
        return contentValues;
    }

    @TargetApi(value=29)
    private Uri getUri(ContentResolver contentResolver, @Nullable String type, ContentValues values) {
        switch (type != null ? type : "") {
            case "image": {
                return contentResolver.insert(MediaStore.Images.Media.getContentUri((String)"external_primary"), values);
            }
            case "video": {
                return contentResolver.insert(MediaStore.Video.Media.getContentUri((String)"external_primary"), values);
            }
        }
        return contentResolver.insert(MediaStore.Downloads.getContentUri((String)"external_primary"), values);
    }

    @TargetApi(value=29)
    private String getPendingKey(@Nullable String type) {
        switch (type != null ? type : "") {
            case "image": {
                return "is_pending";
            }
            case "video": {
                return "is_pending";
            }
        }
        return "is_pending";
    }

    @Nullable
    @TargetApi(value=28)
    private Uri applyDownloadUntil29(Activity activity, String filename, ResponseBody body, String rootPath) {
        try {
            String root = Environment.getExternalStoragePublicDirectory((String)rootPath).getAbsolutePath();
            String savePath = String.format("%s/%s/%s", root, "ChannelPlugin", filename);
            String tempPath = String.format("%s/%s", activity.getExternalCacheDir(), RandomUtils.getRandomString(16));
            File downloadedFile = new File(tempPath);
            BufferedSink sink = Okio.buffer((Sink)Okio.sink((File)downloadedFile));
            sink.writeAll((Source)body.source());
            sink.close();
            File file = new File(savePath);
            FileChannel inChannel = new FileInputStream(tempPath).getChannel();
            FileChannel outChannel = new FileOutputStream(savePath).getChannel();
            inChannel.transferTo(0L, inChannel.size(), outChannel);
            inChannel.close();
            outChannel.close();
            File tempFile = new File(tempPath);
            if (tempFile.exists()) {
                tempFile.delete();
            }
            Executor.startFileMediaScan(activity, file);
            if (Build.VERSION.SDK_INT >= 24) {
                return ChannelFileProvider.getUriForFile((Context)activity, file);
            }
            return Uri.fromFile((File)file);
        }
        catch (Exception ex) {
            return null;
        }
    }

    private String getDownloadRootPath(@Nullable String type) {
        if (type == null) {
            return Environment.DIRECTORY_DOWNLOADS;
        }
        switch (type) {
            case "image": {
                return Environment.DIRECTORY_PICTURES;
            }
            case "video": {
                return Environment.DIRECTORY_MOVIES;
            }
        }
        return Environment.DIRECTORY_DOWNLOADS;
    }

    private boolean createDirectory(@Nullable String type) {
        if (Build.VERSION.SDK_INT < 29) {
            try {
                File dir = new File(Environment.getExternalStoragePublicDirectory((String)this.getDownloadRootPath(type)), "ChannelPlugin");
                if (!dir.exists() && !dir.mkdirs()) {
                    throw new Exception("Directory can not created.");
                }
            }
            catch (Exception ex) {
                return false;
            }
        }
        return true;
    }

    @Override
    public void cancel() {
        if (this.downloadSubscription != null && !this.downloadSubscription.isUnsubscribed()) {
            this.downloadSubscription.unsubscribe();
            this.downloadSubscription = null;
        }
    }

    @Override
    public void release() {
        super.release();
        this.cancel();
    }

    private class ProgressResponseBody
    extends ResponseBody {
        private ResponseBody responseBody;
        @Nullable
        private BufferedSource bufferedSource;

        public ProgressResponseBody(ResponseBody responseBody) {
            this.responseBody = responseBody;
        }

        @Nullable
        public MediaType contentType() {
            if (this.responseBody != null) {
                return this.responseBody.contentType();
            }
            return null;
        }

        public long contentLength() {
            if (this.responseBody != null) {
                return this.responseBody.contentLength();
            }
            return 0L;
        }

        private void handleProgress(int progress) {
            DownloadPresenter.this.activity.runOnUiThread(() -> DownloadPresenter.this.view.onProgressUpdate(progress));
        }

        public BufferedSource source() {
            if (this.bufferedSource == null) {
                this.bufferedSource = Okio.buffer((Source)this.source((Source)this.responseBody.source()));
            }
            return this.bufferedSource;
        }

        private Source source(Source source) {
            return new ForwardingSource(source){
                private long totalBytesRead;
                private int progress;
                {
                    this.totalBytesRead = 0L;
                    this.progress = 0;
                }

                public long read(Buffer sink, long byteCount) throws IOException {
                    long bytesRead = super.read(sink, byteCount);
                    this.totalBytesRead += bytesRead != -1L ? bytesRead : 0L;
                    try {
                        int p = (int)(100L * this.totalBytesRead / ProgressResponseBody.this.contentLength());
                        if (p != this.progress) {
                            this.progress = p;
                            ProgressResponseBody.this.handleProgress(p);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return bytesRead;
                }
            };
        }
    }
}

