package com.zoyi.channel.plugin.android.activity.lounge.view;

import android.content.Context;
import android.graphics.Color;
import android.support.annotation.*;
import android.support.v4.content.ContextCompat;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.*;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.selector.BootDataSelector;
import com.zoyi.channel.plugin.android.store.ChannelStore;
import com.zoyi.channel.plugin.android.bind.Binder;
import com.zoyi.channel.plugin.android.util.ComponentUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.button.MaskImageButton;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.textview.CHTextView;

public class LoungeHeaderView extends LinearLayout {

  private TextView textChannel;
  private CHTextView textResponse;
  private ImageView imageResponse;
  private CHTextView textResponseDescription;

  private View layoutWorkingTime;
  private CHTextView textWorkingTime;
  private MaskImageButton imageWorkingTime;

  private MaskImageButton settingsButton;
  private MaskImageButton closeButton;

  @ColorInt
  private int darkTextColor;

  @Nullable
  private Binder binder;

  @Nullable
  private LoungeHeaderInteractionListener loungeHeaderInteractionListener;

  public LoungeHeaderView(@NonNull Context context) {
    super(context);
    init(context);
  }

  public LoungeHeaderView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context);
  }

  public LoungeHeaderView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context);
  }

  private void init(@NonNull Context context) {
    View view = LayoutInflater.from(context).inflate(R.layout.ch_plugin_view_lounge_header, this, true);

    textChannel = view.findViewById(R.id.ch_textLoungeHeader);
    textResponse = view.findViewById(R.id.ch_textLoungeHeaderResponseDelay);
    imageResponse = view.findViewById(R.id.ch_imageLoungeHeaderResponseDelay);
    textResponseDescription = view.findViewById(R.id.ch_textLoungeHeaderResponseDelayDescription);

    layoutWorkingTime = findViewById(R.id.ch_layoutLoungeHeaderWorkingTime);
    textWorkingTime = findViewById(R.id.ch_textLoungeHeaderWorkingTime);
    imageWorkingTime = findViewById(R.id.ch_iconLoungeHeaderWorkingTime);

    darkTextColor = ContextCompat.getColor(context, R.color.ch_grey900);

    settingsButton = view.findViewById(R.id.ch_buttonLoungeSettings);
    closeButton = view.findViewById(R.id.ch_buttonLoungeClose);

    // attach event handler

    layoutWorkingTime.setOnClickListener(v -> {
      Channel channel = ChannelStore.get().channelState.get();

      String workingTimeText = channel != null ? channel.getWorkingTimeText() : null;

      if (!TextUtils.isEmpty(workingTimeText)) {
        new ChannelDialog(context).setDescription(workingTimeText).show();
      }
    });

    settingsButton.setOnClickListener(v -> {
      if (loungeHeaderInteractionListener != null) {
        loungeHeaderInteractionListener.onSettingsClick();
      }
    });
    closeButton.setOnClickListener(v -> {
      if (loungeHeaderInteractionListener != null) {
        loungeHeaderInteractionListener.onExitClick();
      }
    });

  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    binder = BootDataSelector.bindBootData((plugin, channel, remainMinutes) -> {
      textChannel.setTextColor(plugin.getTextColor());

      if (plugin.getTextColor() == Color.WHITE) {
        textResponse.setTextColor(Color.WHITE);
        textResponseDescription.setTextColor(Color.WHITE);
        textWorkingTime.setTextColor(Color.WHITE);
        imageWorkingTime.setColor(Color.WHITE);
      } else {
        textResponse.setTextColor(darkTextColor);
        textResponseDescription.setTextColor(darkTextColor);
        textWorkingTime.setTextColor(darkTextColor);
        imageWorkingTime.setColor(darkTextColor);
      }

      Views.setVisibility(layoutWorkingTime, channel.hasValidWorkingTime());

      textChannel.setText(channel.getName());

      textResponse.setTextKey(ComponentUtils.getResponseKey(channel, remainMinutes == 0));
      textResponseDescription.setText(ComponentUtils.getShortResponseDescription(channel, remainMinutes));

      imageResponse.setImageResource(ComponentUtils.getResponseSymbol(plugin, channel, remainMinutes == 0));

      // buttons
      settingsButton.setColor(plugin.getTextColor());
      closeButton.setColor(plugin.getTextColor());
    });
  }

  @Override
  protected void onDetachedFromWindow() {
    super.onDetachedFromWindow();

    if (binder != null) {
      binder.unbind();
      binder = null;
    }
  }

  public void setLoungeHeaderInteractionListener(
      @Nullable LoungeHeaderInteractionListener loungeHeaderInteractionListener
  ) {
    this.loungeHeaderInteractionListener = loungeHeaderInteractionListener;
  }
}
