/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.view.reactions;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v7.widget.AppCompatImageView;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.Utils;
import com.zoyi.com.bumptech.glide.Glide;
import com.zoyi.com.bumptech.glide.load.engine.DiskCacheStrategy;

public class ReactionsTabView
extends FrameLayout {
    private Context context;
    private AppCompatImageView imageReactionItem;
    private TextView textReactionItemCount;

    public ReactionsTabView(@NonNull Context context) {
        super(context);
        this.init(context);
    }

    public ReactionsTabView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    @Initializer
    private void init(Context context) {
        LayoutInflater.from((Context)context).inflate(R.layout.ch_view_reactions_tab, (ViewGroup)this);
        this.context = context;
        this.imageReactionItem = (AppCompatImageView)this.findViewById(R.id.ch_imageReactionItem);
        this.textReactionItemCount = (TextView)this.findViewById(R.id.ch_textReactionItemCount);
    }

    public void bind(String emojiName, @Nullable Integer count) {
        Glide.with((Context)this.context).load(String.format("https://cf.channel.io/asset/emoji/images/44/%s.png", emojiName)).centerCrop().dontAnimate().diskCacheStrategy(DiskCacheStrategy.SOURCE).into((ImageView)this.imageReactionItem);
        this.textReactionItemCount.setText((CharSequence)Utils.getCount(count != null ? count : 0, false));
    }

    public void setBold(boolean bold) {
        this.textReactionItemCount.setTypeface(null, bold ? 1 : 0);
    }
}

