package com.zoyi.channel.plugin.android.activity.profile.view;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.widget.FrameLayout;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.*;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

public class EditProfileNumberView extends FrameLayout implements BaseEditProfileView {

  private WatchedEditText editText;
  private View clearButton;

  public EditProfileNumberView(@NonNull Context context) {
    super(context);

    init(context);
  }

  public EditProfileNumberView(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);

    init(context);
  }

  public EditProfileNumberView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);

    init(context);
  }

  @Initializer
  @Override
  public void init(Context context) {
    View root = LayoutInflater.from(context).inflate(R.layout.ch_view_edit_profile_number, this, true);

    editText = root.findViewById(R.id.ch_editEditProfileNumber);
    clearButton = root.findViewById(R.id.ch_buttonEditProfileNumberClearText);

    editText.setWatchedTextChangedListener(s -> Views.setVisibility(clearButton, !TextUtils.isEmpty(s)));
    clearButton.setOnClickListener(v -> editText.setText(null));
  }

  @Override
  public void focus() {
    if (editText != null) {
      editText.requestFocus();
    }
  }

  @Override
  public boolean isValidValue() {
    String text = editText.getString().trim();

    if (text.isEmpty()) {
      return true;
    }
    return ParseUtils.parseNumber(text) != null;
  }

  @Nullable
  @Override
  public Object getValue() {
    return ParseUtils.parseNumber(editText.getString().trim());
  }

  @Override
  public void setValue(@Nullable Object value) {
    if (editText != null) {
      if (value != null) {
        editText.setText(value.toString());
      } else {
        editText.setText(null);
      }
    }
  }
}
