/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.repo.EmptyRepo;
import com.zoyi.channel.plugin.android.model.repo.LoungeChatsRepo;
import com.zoyi.channel.plugin.android.model.repo.ManagersRepo;
import com.zoyi.channel.plugin.android.model.repo.MessageRepo;
import com.zoyi.channel.plugin.android.model.repo.MessagesRepo;
import com.zoyi.channel.plugin.android.model.repo.PluginRepo;
import com.zoyi.channel.plugin.android.model.repo.ProfileBotSchemasRepo;
import com.zoyi.channel.plugin.android.model.repo.SupportBotRepo;
import com.zoyi.channel.plugin.android.model.repo.TranslationRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatRepo;
import com.zoyi.channel.plugin.android.model.repo.UserChatsRepo;
import com.zoyi.channel.plugin.android.model.repo.UserRepo;
import com.zoyi.channel.plugin.android.model.rest.AppMessengerUri;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.MediaChannelApi;
import com.zoyi.channel.plugin.android.network.ProgressRequestBody;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.network.SimpleChannelApi;
import com.zoyi.channel.plugin.android.open.callback.BootCallback;
import com.zoyi.channel.plugin.android.open.config.BootConfig;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.Body;
import com.zoyi.retrofit2.http.Header;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Collections;
import java.util.List;

public class Api<E> {
    @Nullable
    private static ChannelApi channelApi;
    @Nullable
    private static SimpleChannelApi simpleChannelApi;
    @Nullable
    private static MediaChannelApi mediaChannelApi;
    private Observable<E> observable;
    @Nullable
    private ActionType actionType;
    @Nullable
    private ActionType[] cancelTypes;

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    public static SimpleChannelApi getSimpleApi() {
        if (simpleChannelApi == null) {
            simpleChannelApi = ServiceFactory.simpleCreate();
        }
        return simpleChannelApi;
    }

    public static MediaChannelApi getMediaApi() {
        if (mediaChannelApi == null) {
            mediaChannelApi = ServiceFactory.mediaCreate();
        }
        return mediaChannelApi;
    }

    public static boolean isRunning(ActionType actionType) {
        return Action.isRunning(actionType);
    }

    public Api(Observable<E> observable) {
        this.observable = observable.onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Api<E> runBy(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public Api<E> cancelBy(ActionType ... actionTypes) {
        this.cancelTypes = actionTypes;
        return this;
    }

    public Subscription run(RestSubscriber<E> subscriber) {
        return Action.apiSubscribe(this.observable, subscriber, this.actionType, this.cancelTypes);
    }

    public Subscription run() {
        return Action.apiSubscribe(this.observable, new RestSubscriber(), this.actionType, this.cancelTypes);
    }

    public static Api<PluginRepo> boot(@Nullable BootConfig bootConfig, @Nullable BootCallback bootCallback) {
        if (CompareUtils.isSame("production", "production") && CompareUtils.isSame("release", "release")) {
            return new Api<PluginRepo>(Api.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "8.0.2").filter(packageInfo -> BootManager.isValidVersion(packageInfo, bootCallback)).flatMap(__ -> BootManager.bootPlugin(bootConfig)).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, bootCallback)));
        }
        return new Api<PluginRepo>(BootManager.bootPlugin(bootConfig).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, bootCallback)));
    }

    public static Api<EmptyRepo> sendToken(@Body RequestBody body, @Header(value="x-session") String jwt) {
        return new Api<EmptyRepo>(Api.getApi().sendToken(body, jwt));
    }

    public static Api<Void> trackEvent(String pluginId, String name, String property, String sessionJWT) {
        return new Api<Void>(Api.getSimpleApi().trackEvent(pluginId, name, property, sessionJWT));
    }

    public static Api<UserChatsRepo> getUserChats(String sortField, String sortOrder, Integer limit, boolean includeClosed) {
        return new Api<UserChatsRepo>(Api.getApi().getUserChats(sortField, sortOrder, limit, includeClosed));
    }

    public static Api<UserChatsRepo> getUserChats(String sortField, String sortOrder, Integer limit, boolean includeClosed, String since) {
        return new Api<UserChatsRepo>(Api.getApi().getUserChatsNext(sortField, sortOrder, limit, includeClosed, since));
    }

    public static Api<UserRepo> touch(String key, String jwt) {
        return new Api<UserRepo>(Api.getSimpleApi().touch(key, jwt));
    }

    public static Api<UserChatRepo> getUserChat(String userChatId) {
        return new Api<UserChatRepo>(Api.getApi().getUserChat(userChatId));
    }

    public static Api<UserChatRepo> removeUserChat(String userChatId) {
        return new Api<UserChatRepo>(Api.getApi().removeUserChat(userChatId));
    }

    public static Api<MessagesRepo> getMessages(String userChatId, @Nullable String since, Integer limit, String sortOrder) {
        return new Api<MessagesRepo>(Api.getApi().getMessages(userChatId, since, limit, sortOrder));
    }

    public static Api<UserChatRepo> createUserChat(String pluginId, String url) {
        return new Api<UserChatRepo>(Api.getApi().createUserChat(pluginId, url));
    }

    public static Api<UserChatRepo> createSupportBotUserChat(String supportBotId, String url) {
        return new Api<UserChatRepo>(Api.getApi().createSupportBotUserChat(supportBotId, url));
    }

    public static Api<MessageRepo> sendMessage(String userChatId, RequestBody body) {
        return new Api<MessageRepo>(Api.getApi().sendMessage(userChatId, body));
    }

    public static Api<MessageRepo> uploadFile(String channelId, String chatId, String requestId, ProgressRequestBody requestBody) {
        return new Api<MessageRepo>(Api.getMediaApi().uploadFile(channelId, requestBody.getName(), requestBody).flatMap(fileObject -> Api.getApi().sendMessage(chatId, RequestUtils.form().set("requestId", requestId).set("files", Collections.singletonList(fileObject)).create())));
    }

    public static Api<MessageRepo> closeUserChat(String userChatId, @Nullable String actionId, String requestId) {
        return new Api<MessageRepo>(Api.getApi().closeUserChat(userChatId, actionId, requestId));
    }

    public static Api<MessageRepo> reviewUserChat(String userChatId, @Nullable String actionId, String requestId, String review) {
        return new Api<MessageRepo>(Api.getApi().reviewUserChat(userChatId, actionId, requestId, review));
    }

    public static Api<MessageRepo> submitButtonAction(String userChatId, @Nullable String buttonId, @Nullable String messageId, @Nullable String requestId) {
        return new Api<MessageRepo>(Api.getApi().submitButtonAction(userChatId, buttonId, messageId, requestId));
    }

    public static Api<Void> read(String chatId) {
        return new Api<Void>(Api.getApi().read(chatId));
    }

    public static Api<TranslationRepo> getTranslatedMessage(String userChatId, String messageId, String language) {
        return new Api<TranslationRepo>(Api.getApi().getTranslatedMessage(userChatId, messageId, language));
    }

    public static Api<List<Country>> getCountries() {
        return new Api<List<Country>>(Api.getApi().getCountries());
    }

    public static Api<MessageRepo> updateProfileBot(String userChatId, String messageId, RequestBody requestBody) {
        return new Api<MessageRepo>(Api.getApi().updateProfileBot(userChatId, messageId, requestBody));
    }

    public static Api<ProfileBotSchemasRepo> getProfileBotSchemas(String pluginId) {
        return new Api<ProfileBotSchemasRepo>(Api.getApi().getProfileBotSchemas(pluginId));
    }

    public static Api<UserRepo> updateUser(RequestBody body) {
        return new Api<UserRepo>(Api.getApi().updateUser(body));
    }

    public static Api<Void> closePopUp() {
        return new Api<Void>(Api.getApi().closePopUp());
    }

    public static Api<LoungeChatsRepo> getLoungeData(String pluginId, @Nullable String url, boolean showClosedChats) {
        return new Api<LoungeChatsRepo>(Observable.zip(Api.getApi().getLounge(pluginId, url), Api.getApi().getUserChats("updatedAt", "DESC", 50, showClosedChats), LoungeChatsRepo::new));
    }

    public static Api<AppMessengerUri> getMessengerConnect(String appMessengerName) {
        return new Api<AppMessengerUri>(Api.getApi().getMessengerConnect(appMessengerName));
    }

    public static Api<MessageRepo> createMarketingSupportBotUserChat(String userChatId, String supportBotId, @Nullable String sourceType, @Nullable String sourceId) {
        return new Api<MessageRepo>(Api.getMarketingSupportBot(sourceType, sourceId).map(supportBotRepo -> {
            if (supportBotRepo.getSupportBot() != null && supportBotRepo.getSupportBot().getId() != null) {
                return supportBotRepo.getSupportBot().getId();
            }
            return supportBotId;
        }).flatMap(id2 -> Api.getApi().createMarketingSupportBotUserChat(userChatId, (String)id2)));
    }

    public static Api<Void> sendCampaignClickEvent(String marketingId, String userId, @Nullable String url) {
        return new Api<Void>(Api.getApi().campaignClick(marketingId, userId, url));
    }

    public static Api<Void> sendCampaignViewEvent(String marketingId) {
        return new Api<Void>(Api.getApi().campaignView(marketingId));
    }

    public static Api<Void> oneTimeMsgClick(String marketingId, String userId, @Nullable String url) {
        return new Api<Void>(Api.getApi().oneTimeMsgClick(marketingId, userId, url));
    }

    public static Api<Void> oneTimeMsgView(String marketingId) {
        return new Api<Void>(Api.getApi().oneTimeMsgView(marketingId));
    }

    public static Api<UserRepo> addTags(@Nullable List<String> tags) {
        return new Api<UserRepo>(Api.getApi().addTags(tags));
    }

    public static Api<UserRepo> removeTags(@Nullable List<String> tags) {
        return new Api<UserRepo>(Api.getApi().removeTags(tags));
    }

    public static Api<Void> deleteToken(String key, @Nullable String userId) {
        return new Api<Void>(Api.getApi().deleteToken(key, userId));
    }

    public static Api<MessageRepo> deleteMessage(String userChatId, String messageId) {
        return new Api<MessageRepo>(Api.getApi().deleteMessage(userChatId, messageId));
    }

    public static Api<ManagersRepo> getManagers(List<String> managerIds) {
        return new Api<ManagersRepo>(Api.getApi().getManagers(managerIds));
    }

    private static Observable<SupportBotRepo> getMarketingSupportBot(@Nullable String sourceType, @Nullable String sourceId) {
        if (sourceType != null) {
            switch (sourceType) {
                case "campaign": {
                    return Api.getApi().getCampaignSupportBot(sourceId);
                }
                case "oneTimeMsg": {
                    return Api.getApi().getOneTimeMessageSupportBot(sourceId);
                }
            }
        }
        return Observable.empty();
    }
}

