package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.BuildConfig;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.global.*;
import com.zoyi.channel.plugin.android.model.repo.PackageRepo;
import com.zoyi.channel.plugin.android.model.repo.PluginRepo;
import com.zoyi.channel.plugin.android.network.HttpStatus;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.open.callback.BootCallback;
import com.zoyi.channel.plugin.android.open.config.BootConfig;
import com.zoyi.channel.plugin.android.open.enumerate.BootStatus;
import com.zoyi.rx.Observable;

/**
 * Created by jerry on 2018. 10. 17..
 */

public class BootManager {

  public static Observable<PluginRepo> bootPlugin(BootConfig bootConfig) {
    String veilId = PrefSupervisor.getVeilId(ChannelIO.getAppContext());
    if (veilId != null && veilId.length() > 16) {
      veilId = veilId.substring(0, 16);
    }

    return Api.getSimpleApi().boot(
        bootConfig.getLanguage().toString(),
        bootConfig.getPluginKey(),
        bootConfig.getMemberId(),
        bootConfig.getMemberHash(),
        bootConfig.getUnsubscribed(),
        null,
        bootConfig.getProfile(),
        veilId
    );
  }

  public static boolean isValidVersion(PackageRepo packageRepo, BootCallback bootCallback) {

    if (packageRepo == null) {
      if (bootCallback != null) {
        bootCallback.onComplete(BootStatus.NETWORK_TIMEOUT, null);
      }
      return false;
    }

    if (packageRepo.isNeedToUpgrade()) {
      if (bootCallback != null) {
        bootCallback.onComplete(BootStatus.NOT_AVAILABLE_VERSION, null);
      }
      return false;
    }

    if (!CompareUtils.isSame(packageRepo.getVersionString(), BuildConfig.CHANNEL_IO_VERSION)) {
      L.i("Newest version is: " + packageRepo.getVersionString());
    }

    return true;
  }

  public static boolean isValidPlugin(PluginRepo pluginRepo, BootCallback bootCallback) {
    if (pluginRepo == null || !pluginRepo.isValid()) {
      if (bootCallback != null) {
        bootCallback.onComplete(BootStatus.NOT_AVAILABLE_VERSION, null);
      }
      return false;
    }

    return true;
  }

  public static void sendNetworkError(BootCallback bootCallback, RetrofitException exception) {
    if (bootCallback != null) {
      String errorMessage = Const.ERROR_UNKNOWN;
      if (exception != null) {
        BootStatus status;
        errorMessage = exception.getMessage();

        if (exception.getHttpStatus() == HttpStatus.PAYMENT_REQUIRED) {
          status = BootStatus.REQUIRE_PAYMENT;
        } else if (exception.is4xxClientError()) {
          status = BootStatus.ACCESS_DENIED;
        } else if (exception.is5xxServerError()) {
          status = BootStatus.SERVICE_UNDER_CONSTRUCTION;
        } else if (exception.isConnectionTimeOutError()) {
          status = BootStatus.NETWORK_TIMEOUT;
        } else if (exception.isHttpError()) {
          status = BootStatus.NOT_INITIALIZED;
        } else {
          status = BootStatus.UNKNOWN_ERROR;
        }

        bootCallback.onComplete(status, null);
      } else {
        bootCallback.onComplete(BootStatus.UNKNOWN_ERROR, null);
      }

      L.e(errorMessage);
    }
  }
}
