package com.zoyi.channel.plugin.android.deserializer;

import android.text.TextUtils;

import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ParseUtils;
import com.zoyi.channel.plugin.android.util.lang.StringUtils;
import com.zoyi.channel.plugin.android.util.message.MessageParseOptions;
import com.zoyi.channel.plugin.android.util.message.MessageParserUtils;
import com.zoyi.com.annimon.stream.Stream;
import com.zoyi.com.google.gson.*;

import java.lang.reflect.Type;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class MessageDeserializer implements JsonDeserializer {

  private Gson gson;
  private MessageParseOptions options;

  public MessageDeserializer() {
    GsonBuilder builder = new GsonBuilder();
    builder.registerTypeAdapter(ProfileBot.class, new ProfileBotDeserializer());

    this.gson = builder.create();
    this.options = MessageParseOptions.MessageParseOptionsBuilder.create()
        .withEnableVariable(false)
        .build();
  }

  @Override
  public Object deserialize(JsonElement json, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
    Message message = gson.fromJson(json, type);

    if (message != null) {
      if (message.getBlocks() != null && !message.getBlocks().isEmpty()) {
        BlockParseResult result = MessageParserUtils.parseBlocks(message.getBlocks(), options, message.getMarketing());

        message.setPlainText(result.getPlainText());
      }

      if (TextUtils.isEmpty(message.getPlainText()) && message.getWebPage() != null) {
        message.setPlainText(message.getWebPage().getUrl());
      }

      if (message.getAction() != null && ListUtils.hasItems(message.getAction().getButtons())) {
        for (ActionButton actionButton : message.getAction().getButtons()) {
          actionButton.setMessage(message);
        }

        if (TextUtils.isEmpty(message.getPlainText())) {
          message.setPlainText(
              StringUtils.join(
                  Stream.ofNullable(message.getAction().getButtons())
                      .map(button -> String.format("[%s]", MessageParserUtils.parseText(button.getText(), options).toString()))
                      .toList(),
                  ", "
              )
          );
        }
      }
    }
    return message;
  }
}
