package com.zoyi.channel.plugin.android.model.rest;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.com.annimon.stream.Optional;

import java.util.Locale;

/**
 * Created by mika on 2016. 12. 8..
 */
public class WebPage implements Entity, Previewable {

  private String id;
  @Nullable
  private String url;
  @Nullable
  private String title;
  @Nullable
  private String description;
  @Nullable
  private String videoUrl;
  @Nullable
  private String publisher;
  @Nullable
  private Integer width;
  @Nullable
  private Integer height;
  @Nullable
  private String bucket;
  @Nullable
  private String previewKey;

  @Override
  public String getId() {
    return id;
  }

  @Nullable
  @Override
  public String getUrl() {
    return url;
  }

  @Nullable
  public String getTitle() {
    return title;
  }

  @Nullable
  public String getDescription() {
    return description;
  }

  @Nullable
  public String getPublisher() {
    return publisher;
  }

  @Override
  public Integer getWidth() {
    return Optional.ofNullable(width).orElse(0);
  }

  @Override
  public Integer getHeight() {
    return Optional.ofNullable(height).orElse(0);
  }

  @Nullable
  public String getPreviewUrl() {
    if (bucket != null && width != null && height != null && width > 0 && height > 0 && previewKey != null) {
      return String.format(Locale.ENGLISH, "%s/thumb/%dx%d,cover/%s", UriUtils.getCloudFrontUrl(bucket), width, height, previewKey);
    }
    return null;
  }
}
