package com.zoyi.channel.plugin.android.view.coordinator;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.LinearGradient;
import android.graphics.Paint;
import android.graphics.Shader;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.util.AttributeSet;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Utils;

public class LoungeCoordinatorLayout extends GradientHeaderCoordinatorLayout {

  @Nullable
  private Paint overlayPaint;

  public LoungeCoordinatorLayout(@NonNull Context context) {
    super(context);
  }

  public LoungeCoordinatorLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
  }

  public LoungeCoordinatorLayout(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
  }

  @Override
  protected int getBackgroundHeight() {
    return super.getBackgroundHeight() + (int) Utils.dpToPx(115);
  }

  @Override
  protected void applyPaint(int backgroundHeight) {
    LinearGradient overlayGradient = new LinearGradient(
        0,
        getBackgroundHeight() - (int) Utils.dpToPx(100),
        0,
        getBackgroundHeight(),
        ContextCompat.getColor(getContext(), R.color.ch_transparent),
        ContextCompat.getColor(getContext(), R.color.ch_grey100),
        Shader.TileMode.CLAMP
    );

    if (overlayPaint == null) {
      overlayPaint = new Paint();
    }
    overlayPaint.clearShadowLayer();
    overlayPaint.setShader(overlayGradient);

    super.applyPaint(backgroundHeight);
  }

  @Override
  protected void drawBackground(Canvas canvas) {
    super.drawBackground(canvas);
    if (overlayPaint != null) {
      canvas.drawRect(0, getBackgroundHeight() - (int) Utils.dpToPx(100), getWidth(), getBackgroundHeight(), overlayPaint);
    }
  }
}
