package com.zoyi.channel.plugin.android.view.textview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.ColorRes;
import android.support.annotation.Nullable;
import android.support.v4.content.ContextCompat;
import android.text.Spanned;
import android.util.AttributeSet;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.selector.SettingsSelector;
import com.zoyi.channel.plugin.android.store.SettingsStore;
import com.zoyi.channel.plugin.android.store.binder.Binder;
import com.zoyi.channel.plugin.android.util.*;

public class CHTextView extends android.support.v7.widget.AppCompatTextView {

  private Context context;

  @Nullable
  private String textKey;

  private boolean isHtml;

  @Nullable
  private Binder binder;

  public CHTextView(Context context) {
    super(context);
    init(context, null);
  }

  public CHTextView(Context context, @Nullable AttributeSet attrs) {
    super(context, attrs);
    init(context, attrs);
  }

  public CHTextView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
    super(context, attrs, defStyleAttr);
    init(context, attrs);
  }

  @Initializer
  private void init(Context context, @Nullable AttributeSet attrs) {
    this.context = context;

    if (attrs != null) {
      TypedArray typedArray = getContext().obtainStyledAttributes(attrs, R.styleable.CHTextView);
      try {
        textKey = typedArray.getString(R.styleable.CHTextView_ch_tv_textKey);
        isHtml = typedArray.getBoolean(R.styleable.CHTextView_ch_tv_isHtml, false);
      } finally {
        typedArray.recycle();
      }
    }
  }

  @Override
  protected void onAttachedToWindow() {
    super.onAttachedToWindow();

    if (!isInEditMode()) {
      binder = SettingsSelector.bindLocale(locale -> {
        if (textKey != null) {
          setTextKey(locale, textKey);
        }
      });
    }
  }

  @Override
  protected void onDetachedFromWindow() {
    if (binder != null) {
      binder.unbind();
      binder = null;
    }

    super.onDetachedFromWindow();
  }

  public void setText(@Nullable String text) {
    this.textKey = null;

    super.setText(text);
  }

  public void setText(@Nullable Spanned text) {
    this.textKey = null;

    super.setText(text);
  }

  public void setTextKey(@Nullable String textKey) {
    this.textKey = textKey;

    setTextKey(SettingsStore.get().locale.get(), textKey);
  }

  private void setTextKey(CHLocale locale, @Nullable String textKey) {
    if (textKey != null) {
      String content = ResUtils.getString(context, locale, textKey);

      setContent(content);
    }
  }

  private void setContent(@Nullable String content) {
    if (isHtml && content != null) {
      super.setText(Utils.getHtmlFormattedText(content));
    } else {
      super.setText(content);
    }
  }
}
