/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Color;
import android.graphics.Point;
import android.os.Build;
import android.text.Html;
import android.text.Spanned;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import com.zoyi.channel.plugin.android.ChannelIO;
import java.util.Random;

public class Utils {
    public static int addBlackMask(int color2) {
        float[] hsv = new float[3];
        Color.colorToHSV((int)color2, (float[])hsv);
        hsv[2] = Math.max(0.0f, hsv[2] - 0.2f);
        return Color.HSVToColor((float[])hsv);
    }

    public static Point resizeImage(Context context, Point imageArea, boolean isWebPage) {
        Point windowSize = Utils.getWindowSize(context);
        if (isWebPage) {
            int width = (int)((float)windowSize.x - Utils.dpToPx(context, 120.0f));
            int height = (int)((double)width * 0.52);
            return new Point(width, height);
        }
        double ratioWidth = 1.0;
        double ratioHeight = 1.0;
        int targetWidth = imageArea.x;
        int targetHeight = imageArea.y;
        if (windowSize.x == 0 || windowSize.y == 0) {
            return new Point(targetWidth, targetHeight);
        }
        double minWidth = (double)windowSize.x * 6.0 / 10.0;
        double maxWidth = (float)windowSize.x - Utils.dpToPx(context, 120.0f);
        double minHeight = (double)windowSize.y * 2.5 / 10.0;
        double maxHeight = (double)windowSize.y * 5.5 / 10.0;
        if ((double)targetWidth > maxWidth) {
            ratioWidth = maxWidth / (double)targetWidth;
        } else if ((double)targetWidth < minWidth) {
            ratioWidth = minWidth / (double)targetWidth;
        }
        if ((double)targetHeight > maxHeight) {
            ratioHeight = maxHeight / (double)targetHeight;
        } else if ((double)targetHeight < minHeight) {
            ratioHeight = minHeight / (double)targetHeight;
        }
        if (ratioWidth > 1.0 && ratioHeight < 1.0) {
            return new Point((int)minWidth, (int)maxHeight);
        }
        if (ratioWidth < 1.0 && ratioHeight > 1.0) {
            return new Point((int)maxWidth, (int)minHeight);
        }
        if (ratioWidth < 1.0 || ratioHeight < 1.0) {
            double ratioMin = Math.min(ratioWidth, ratioHeight);
            targetWidth = Math.max((int)minWidth, (int)((double)targetWidth * ratioMin));
            targetHeight = Math.max((int)minHeight, (int)((double)targetHeight * ratioMin));
        } else if (ratioWidth > 1.0 || ratioHeight > 1.0) {
            double ratioMax = Math.max(ratioWidth, ratioHeight);
            targetWidth = Math.min((int)maxWidth, (int)((double)targetWidth * ratioMax));
            targetHeight = Math.min((int)maxHeight, (int)((double)targetHeight * ratioMax));
        }
        return new Point(targetWidth, targetHeight);
    }

    public static Point resizeImageForGrid(Context context, int size) {
        Point windowSize = Utils.getWindowSize(context);
        double ratioSize = 1.0;
        int targetSize = size;
        if (windowSize.x == 0 || windowSize.y == 0) {
            return new Point(targetSize, targetSize);
        }
        double minSize = Utils.dpToPx(56.0f);
        double maxSize = ((float)windowSize.x - Utils.dpToPx(context, 121.0f)) / 2.0f;
        if ((double)targetSize > maxSize) {
            ratioSize = maxSize / (double)targetSize;
        }
        if (ratioSize < 1.0) {
            targetSize = Math.max((int)minSize, (int)maxSize);
        } else if (ratioSize > 1.0) {
            targetSize = Math.max((int)minSize, targetSize);
        }
        return new Point(targetSize, targetSize);
    }

    public static Point getWindowSize(Context context) {
        Point windowSize = new Point();
        WindowManager wm = (WindowManager)context.getSystemService("window");
        wm.getDefaultDisplay().getSize(windowSize);
        return windowSize;
    }

    public static float dpToPx(Context context, float dp) {
        Resources resources = context.getResources();
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    public static float dpToPx(float dp) {
        return Utils.dpToPx(ChannelIO.getAppContext(), dp);
    }

    public static String getCount(int count, boolean emptyIfZero) {
        return Utils.getCount((long)count, emptyIfZero);
    }

    public static String getCount(long count, boolean emptyIfZero) {
        if (count <= 0L && emptyIfZero) {
            return "";
        }
        return count >= 100L ? "99+" : String.valueOf(count);
    }

    public static Spanned getHtmlFormattedText(String text) {
        if (Build.VERSION.SDK_INT >= 24) {
            return Html.fromHtml((String)text, (int)0);
        }
        return Html.fromHtml((String)text);
    }

    public static boolean hasPermissionInManifest(Context context, String permissionName) {
        String packageName = context.getPackageName();
        try {
            PackageInfo packageInfo = context.getPackageManager().getPackageInfo(packageName, 4096);
            String[] declaredPermisisons = packageInfo.requestedPermissions;
            if (declaredPermisisons != null && declaredPermisisons.length > 0) {
                for (String p : declaredPermisisons) {
                    if (!p.equals(permissionName)) continue;
                    return true;
                }
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            // empty catch block
        }
        return false;
    }

    public static String getRandomString(int length) {
        Random random = new Random();
        StringBuilder stringBuilder = new StringBuilder(length);
        String ALLOWED_CHARACTERS = "0123456789abcdefghijklmnopqrstuvwxyz";
        for (int i = 0; i < length; ++i) {
            stringBuilder.append(ALLOWED_CHARACTERS.charAt(random.nextInt(ALLOWED_CHARACTERS.length())));
        }
        return stringBuilder.toString();
    }
}

