package com.zoyi.channel.plugin.android.activity.profile;

import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.text.TextUtils;
import android.view.View;
import android.widget.TextView;

import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.action.CountryAction;
import com.zoyi.channel.plugin.android.action.UserAction;
import com.zoyi.channel.plugin.android.activity.base.BaseActivity2;
import com.zoyi.channel.plugin.android.activity.chat.model.MobileNumber;
import com.zoyi.channel.plugin.android.activity.common.navigation.NavigationView;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.rest.ProfileBotSchema;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.selector.ProfileBotSelector;
import com.zoyi.channel.plugin.android.store.CountryStore;
import com.zoyi.channel.plugin.android.util.Initializer;
import com.zoyi.channel.plugin.android.util.ResUtils;
import com.zoyi.channel.plugin.android.util.Views;
import com.zoyi.channel.plugin.android.view.dialog.ChannelDialog;
import com.zoyi.channel.plugin.android.view.dialog.CountryCodeDialog;
import com.zoyi.channel.plugin.android.view.layout.WatchedEditText;

import java.util.List;
import java.util.Locale;

import static android.text.InputType.TYPE_CLASS_NUMBER;
import static android.text.InputType.TYPE_CLASS_TEXT;
import static android.text.InputType.TYPE_NUMBER_FLAG_DECIMAL;

public class EditProfileActivity extends BaseActivity2 {

  private NavigationView navigation;

  private View buttonSelectCountry;
  private TextView textSelectCountry;
  private WatchedEditText editText;
  private View clearText;

  @Nullable
  private String key;

  private boolean isNumeric = false;

  // only for mobile number
  private int countryCode;

  @Initializer
  @Override
  protected boolean onCreate() {
    init(R.layout.ch_plugin_activity_edit_profile);

    navigation = findViewById(R.id.navigationEditProfile);
    buttonSelectCountry = findViewById(R.id.buttonEditProfileSelectCountry);
    textSelectCountry = findViewById(R.id.textEditProfileSelectCountry);
    editText = findViewById(R.id.editEditProfileText);
    clearText = findViewById(R.id.buttonEditProfileClearText);

    key = getString(Const.EXTRA_PROFILE_KEY);
    ProfileBotSchema schema = ProfileBotSelector.getProfileBotSchemaByKey(key);

    if (key == null || schema == null) {
      return false;
    }

    navigation.setTitle(schema.getNameI18n().get());
    navigation.addAction(ResUtils.getString("ch.settings.save"), v -> save());

    buttonSelectCountry.setOnClickListener(v -> requestCountrySelector());
    clearText.setOnClickListener(v -> editText.setText(""));
    editText.setWatchedTextChangedListener(s -> Views.setVisibility(clearText, !TextUtils.isEmpty(s)));

    if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(key)) {
      editText.setInputType(TYPE_CLASS_NUMBER | TYPE_NUMBER_FLAG_DECIMAL);
      initMobileNumber(getString(Const.EXTRA_PROFILE_VALUE));
    } else {
      if (Const.PROFILE_TYPE_NUMBER.equals(schema.getType())) {
        isNumeric = true;
        editText.setInputType(TYPE_CLASS_NUMBER | TYPE_NUMBER_FLAG_DECIMAL);
      } else {
        editText.setInputType(TYPE_CLASS_TEXT);
      }
      init(getString(Const.EXTRA_PROFILE_VALUE));
    }

    return true;
  }

  @Override
  protected void onStart() {
    super.onStart();

    editText.requestFocus();
  }

  @Initializer
  private void init(@Nullable String value) {
    buttonSelectCountry.setVisibility(View.GONE);
    editText.setText(value);
  }

  @Initializer
  private void initMobileNumber(@Nullable String value) {
    buttonSelectCountry.setVisibility(View.VISIBLE);

    MobileNumber mobileNumber = new MobileNumber(value);

    countryCode = mobileNumber.getCountryCode();

    textSelectCountry.setText(String.format(Locale.US, "+%d", mobileNumber.getCountryCode()));
    editText.setText(mobileNumber.getPhoneNumber());
  }

  private void requestCountrySelector() {
    List<Country> countries = CountryStore.get().countries.get();

    if (countries == null) {
      showProgress(ResUtils.getString(this, "ch.loading_information"));

      CountryAction.fetchCountries(new RestSubscriber<List<Country>>() {
        @Override
        public void onError(RetrofitException error) {
          hideProgress();
        }

        @Override
        public void onSuccess(@NonNull List<Country> countries) {
          hideProgress();

          CountryStore.get().countries.set(countries);

          if (countries.size() > 0) {
            openCountrySelector(countries);
          }
        }
      });
    } else {
      openCountrySelector(countries);
    }
  }

  private void openCountrySelector(List<Country> countries) {
    new CountryCodeDialog(this, countries, (position, countryCode) -> {
      try {
        this.countryCode = Integer.valueOf(countryCode);
        textSelectCountry.setText(String.format("+%s", countryCode));
      } catch (Exception ignored) {
      }
    }).show();
  }

  private void save() {
    String value = editText.getString();

    if (Const.PROFILE_MOBILE_NUMBER_KEY.equals(key)) {
      if (TextUtils.isEmpty(value)) {
        updateProfile(null);
      } else {
        updateProfile(String.format(Locale.US, "+%d%s", countryCode, value));
      }
    } else {
      if (TextUtils.isEmpty(value)) {
        updateProfile(null);
      } else {
        updateProfile(value);
      }
    }
  }

  private void updateProfile(@Nullable String value) {
    showProgress();

    UserAction.updateUserProfile(key, value, isNumeric, () -> {
      hideProgress();
      finish();
    }, (message) -> {
      hideProgress();

      if (message != null) {
        new ChannelDialog(this).setDescription(message).show();
      }
    });
  }
}
