package com.zoyi.channel.plugin.android.util.message;

import android.support.annotation.Nullable;
import android.text.SpannableStringBuilder;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.etc.BlockParseResult;
import com.zoyi.channel.plugin.android.model.rest.Block;
import com.zoyi.channel.plugin.android.model.rest.Marketing;

import java.util.*;

public class MessageParserUtils {

  public static BlockParseResult parseBlocks(@Nullable List<Block> blocks) {
    return parseBlocks(blocks, getDefaultParseOption(), null);
  }

  public static BlockParseResult parseBlocks(@Nullable List<Block> blocks, MessageParseOptions options) {
    return parseBlocks(blocks, options, null);
  }

  public static BlockParseResult parseBlocks(@Nullable List<Block> blocks, MessageParseOptions options, @Nullable Marketing marketing) {
    BlockParseResult blockParseResult = new BlockParseResult();

    if (blocks == null) {
      return blockParseResult;
    }

    // Show emoji when block is single only
    boolean showGiantEmoji = blocks.size() == 1;

    Queue<Block> blockQueue = new LinkedList<>(blocks);

    while (blockQueue.size() != 0) {
      Block block = blockQueue.poll();
      String type = block.getType();

      try {
        if (type != null && block.getValue() != null && !block.getValue().isEmpty()) {
          switch (type) {
            case Const.BLOCK_TYPE_TEXT:
              BlockParseResult result = (new MessageParser(options, marketing)).parse(block.getValue());
              block.setFormattedSpanMessage(result.getPlainTextBuilder());
              block.setHasOnlyEmoji(result.hasOnlyEmoji() && showGiantEmoji);
              blockParseResult.append(result);
              break;
            case Const.BLOCK_TYPE_CODE:
              block.setFormattedSpanMessage(new SpannableStringBuilder(block.getValue()));
              blockParseResult.append(block.getValue());
              break;
          }
        } else if (block.getBlocks() != null && !block.getBlocks().isEmpty()) {
          blockQueue.addAll(block.getBlocks());
        }
      } catch (Exception ignored) {
      }
    }

    return blockParseResult;
  }

  public static SpannableStringBuilder parseText(@Nullable String parseText) {
    return parseText(parseText, getDefaultParseOption());
  }

  public static SpannableStringBuilder parseText(@Nullable String parseText, MessageParseOptions options) {
    if (parseText == null) {
      return new SpannableStringBuilder();
    }
    return new MessageParser(options)
        .parse(parseText)
        .getPlainTextBuilder();
  }

  // private functions

  private static MessageParseOptions getDefaultParseOption() {
    return MessageParseOptions.MessageParseOptionsBuilder.create()
        .withEnableVariable(false)
        .build();
  }
}
