/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.mint;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.SharedPreferences;
import android.preference.PreferenceManager;
import android.text.TextUtils;
import com.splunk.mint.ActionEvent;
import com.splunk.mint.BaseDTO;
import com.splunk.mint.LastPing;
import com.splunk.mint.Mint;
import com.splunk.mint.Properties;
import com.splunk.mint.SequentialExecutor;
import com.splunk.mint.Utils;
import java.util.Calendar;
import java.util.TimeZone;

class ForegroundHandler {
    private static final SequentialExecutor executor = new SequentialExecutor();
    private static Application application;
    private static SharedPreferences preferences;
    private static SharedPreferences.Editor editor;
    private static final String LASTMINTTIMESTAMP = "LASTMINTTIMESTAMP";
    private static final String LASTMINTTIMESESSIONID = "LASTMINTTIMESESSIONID";

    ForegroundHandler() {
    }

    static void initialize(Application app) {
        if (application == null) {
            application = app;
        }
    }

    static void applicationMovedToBackground() {
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                ForegroundHandler.setDataSwitchedToBackground();
            }
        });
    }

    static void activityResumed(final Activity activity) {
        if (activity == null) {
            return;
        }
        executor.getExecutor().submit(new Runnable(){

            @Override
            public void run() {
                Properties.BATTERY_LEVEL = Utils.getBatteryLevel((Context)activity);
                Mint.logView(activity.getClass().getName(), null);
                ForegroundHandler.finalizeAndStartNewSession();
            }
        });
    }

    private static synchronized void finalizeAndStartNewSession() {
        DataSwitchedToBackground dataSwitchedToBackground = ForegroundHandler.getAndClearDataSwitchedToBackground();
        long timeSwitchedToBackground = dataSwitchedToBackground.timeSwitchedToBackground;
        String sessionIdSwitchedToBackground = dataSwitchedToBackground.sessionIdSwitchedToBackground;
        if (timeSwitchedToBackground == 0L || TextUtils.isEmpty((CharSequence)sessionIdSwitchedToBackground)) {
            return;
        }
        long currentTime = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
        long lastPingTime = LastPing.getLastPingSentTime(application.getApplicationContext()) / 1000L;
        if (lastPingTime > timeSwitchedToBackground) {
            ActionEvent.createGnip(application.getApplicationContext(), timeSwitchedToBackground, sessionIdSwitchedToBackground).save();
        } else if (currentTime - timeSwitchedToBackground > 300L) {
            ActionEvent.createGnip(application.getApplicationContext(), timeSwitchedToBackground, sessionIdSwitchedToBackground).save();
            LastPing.setLastPingSentTime(application.getApplicationContext());
            ActionEvent.createPing().send(true);
        }
    }

    private static synchronized void setDataSwitchedToBackground() {
        ForegroundHandler.initPreferences(application.getApplicationContext());
        long time = Calendar.getInstance(TimeZone.getTimeZone("UTC")).getTimeInMillis() / 1000L;
        editor.putLong(LASTMINTTIMESTAMP, time).putString(LASTMINTTIMESESSIONID, BaseDTO.getGlobalSessionID()).apply();
    }

    private static synchronized DataSwitchedToBackground getAndClearDataSwitchedToBackground() {
        ForegroundHandler.initPreferences(application.getApplicationContext());
        Long timeSwitchedToBackground = preferences.getLong(LASTMINTTIMESTAMP, 0L);
        String sessionSwitchedToBackground = preferences.getString(LASTMINTTIMESESSIONID, "");
        editor.putLong(LASTMINTTIMESTAMP, 0L).putString(LASTMINTTIMESESSIONID, "").apply();
        return new DataSwitchedToBackground(timeSwitchedToBackground, sessionSwitchedToBackground);
    }

    @SuppressLint(value={"CommitPrefEdits"})
    private static synchronized void initPreferences(Context ctx) {
        if (preferences == null) {
            preferences = PreferenceManager.getDefaultSharedPreferences((Context)ctx);
        }
        if (editor == null) {
            editor = preferences.edit();
        }
    }

    private static class DataSwitchedToBackground {
        long timeSwitchedToBackground = 0L;
        String sessionIdSwitchedToBackground = "";

        public DataSwitchedToBackground(long timeSwitchedToBackground, String sessionIdSwitchedToBackground) {
            this.timeSwitchedToBackground = timeSwitchedToBackground;
            this.sessionIdSwitchedToBackground = sessionIdSwitchedToBackground;
        }
    }
}

