package com.zoyi.channel.plugin.android.model.etc;

import android.text.SpannableStringBuilder;

public class BlockParseResult {
  private SpannableStringBuilder plainTextBuilder;
  private boolean hasOnlyEmoji;

  public BlockParseResult() {
    this(new SpannableStringBuilder(), true);
  }

  public BlockParseResult(SpannableStringBuilder plainTextBuilder, boolean hasOnlyEmoji) {
    this.plainTextBuilder = plainTextBuilder;
    this.hasOnlyEmoji = hasOnlyEmoji;
  }

  public SpannableStringBuilder getPlainTextBuilder() {
    return plainTextBuilder;
  }

  public String getPlainText() {
    return this.plainTextBuilder.toString().trim();
  }

  public boolean hasOnlyEmoji() {
    return hasOnlyEmoji;
  }

  public void append(BlockParseResult result) {
    append(result.getPlainTextBuilder());
  }

  public void append(CharSequence value) {
    this.plainTextBuilder.append(value);
    this.plainTextBuilder.append("\n");
  }
}
