/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginCompletionStatus;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.global.PrefSupervisor;
import com.zoyi.channel.plugin.android.model.wrapper.PackageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.rx.Observable;

public class BootManager {
    public static Observable<PluginWrapper> bootPlugin(ChannelPluginSettings pluginSettings, Profile profile) {
        String veilId = PrefSupervisor.getVeilId(ChannelIO.getAppContext());
        if (veilId != null && veilId.length() > 16) {
            veilId = veilId.substring(0, 16);
        }
        if (profile == null) {
            profile = Profile.create();
        }
        return Api.getSimpleApi().boot(pluginSettings.getLocale().toString(), pluginSettings.getPluginKey(), pluginSettings.getMemberId(), null, profile.toJson(), veilId);
    }

    public static boolean isValidVersion(PackageWrapper packageWrapper, OnBootListener onBootListener) {
        if (packageWrapper == null) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (packageWrapper.isNeedToUpgrade()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NOT_AVAILABLE_VERSION, null);
            }
            return false;
        }
        if (!CompareUtils.isSame(packageWrapper.getVersionString(), "7.0.6")) {
            L.i("Newest version is: " + packageWrapper.getVersionString());
        }
        return true;
    }

    public static boolean isValidPlugin(PluginWrapper pluginWrapper, OnBootListener onBootListener) {
        if (pluginWrapper == null || !pluginWrapper.isValid()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.NETWORK_TIMEOUT, null);
            }
            return false;
        }
        if (!pluginWrapper.canUseMobileSDK()) {
            if (onBootListener != null) {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.REQUIRE_PAYMENT, null);
            }
            return false;
        }
        return true;
    }

    public static void sendNetworkError(OnBootListener onBootListener, RetrofitException exception) {
        if (onBootListener != null) {
            String errorMessage = "Unknown error";
            if (exception != null) {
                errorMessage = exception.getMessage();
                ChannelPluginCompletionStatus status = exception.is4xxClientError() ? ChannelPluginCompletionStatus.ACCESS_DENIED : (exception.is5xxServerError() ? ChannelPluginCompletionStatus.SERVICE_UNDER_CONSTRUCTION : (exception.isConnectionTimeOutError() ? ChannelPluginCompletionStatus.NETWORK_TIMEOUT : (exception.isHttpError() ? ChannelPluginCompletionStatus.NOT_INITIALIZED : ChannelPluginCompletionStatus.UNKNOWN_ERROR)));
                onBootListener.onCompletion(status, null);
            } else {
                onBootListener.onCompletion(ChannelPluginCompletionStatus.UNKNOWN_ERROR, null);
            }
            L.e(errorMessage);
        }
    }
}

