/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.global;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelPluginSettings;
import com.zoyi.channel.plugin.android.OnBootListener;
import com.zoyi.channel.plugin.android.Profile;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Action;
import com.zoyi.channel.plugin.android.model.rest.AppMessengerUri;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.LoungeChatsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessageWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.MessagesWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.PluginWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.ProfileBotSchemasRepo;
import com.zoyi.channel.plugin.android.model.wrapper.TranslationRepo;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.model.wrapper.UserWrapper;
import com.zoyi.channel.plugin.android.network.ChannelApi;
import com.zoyi.channel.plugin.android.network.MediaChannelApi;
import com.zoyi.channel.plugin.android.network.ProgressRequestBody;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.ServiceFactory;
import com.zoyi.channel.plugin.android.network.SimpleChannelApi;
import com.zoyi.channel.plugin.android.util.BootManager;
import com.zoyi.channel.plugin.android.util.CompareUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.Collections;
import java.util.List;

public class Api<E> {
    @Nullable
    private static ChannelApi channelApi;
    @Nullable
    private static SimpleChannelApi simpleChannelApi;
    @Nullable
    private static MediaChannelApi mediaChannelApi;
    private Observable<E> observable;
    @Nullable
    private ActionType actionType;
    @Nullable
    private ActionType[] cancelTypes;

    public static ChannelApi getApi() {
        if (channelApi == null) {
            channelApi = ServiceFactory.create();
        }
        return channelApi;
    }

    public static SimpleChannelApi getSimpleApi() {
        if (simpleChannelApi == null) {
            simpleChannelApi = ServiceFactory.simpleCreate();
        }
        return simpleChannelApi;
    }

    public static MediaChannelApi getMediaApi() {
        if (mediaChannelApi == null) {
            mediaChannelApi = ServiceFactory.mediaCreate();
        }
        return mediaChannelApi;
    }

    public static boolean isRunning(ActionType actionType) {
        return Action.isRunning(actionType);
    }

    private Api(Observable<E> observable) {
        this.observable = observable.onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread());
    }

    public Api<E> runBy(ActionType actionType) {
        this.actionType = actionType;
        return this;
    }

    public Api<E> cancelBy(ActionType ... actionTypes) {
        this.cancelTypes = actionTypes;
        return this;
    }

    public Subscription run(RestSubscriber<E> subscriber) {
        return Action.apiSubscribe(this.observable, subscriber, this.actionType, this.cancelTypes);
    }

    public Subscription run() {
        return Action.apiSubscribe(this.observable, new RestSubscriber(), this.actionType, this.cancelTypes);
    }

    public static Api<PluginWrapper> boot(@Nullable ChannelPluginSettings pluginSettings, @Nullable Profile profile, @Nullable OnBootListener listener) {
        if (CompareUtils.isSame("production", "production") && CompareUtils.isSame("release", "release")) {
            return new Api<PluginWrapper>(Api.getApi().getLastestPackage("com.zoyi.channel.plugin.android", "7.0.4").filter(packageInfo -> BootManager.isValidVersion(packageInfo, listener)).flatMap(__ -> BootManager.bootPlugin(pluginSettings, profile)).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, listener)));
        }
        return new Api<PluginWrapper>(BootManager.bootPlugin(pluginSettings, profile).filter(pluginInfo -> BootManager.isValidPlugin(pluginInfo, listener)));
    }

    public static Api<Void> trackEvent(String pluginId, String name, String property, String sessionJWT) {
        return new Api<Void>(Api.getSimpleApi().trackEvent(pluginId, name, property, sessionJWT));
    }

    public static Api<UserChatsWrapper> getUserChats(String sortField, String sortOrder, Integer limit, boolean includeClosed) {
        return new Api<UserChatsWrapper>(Api.getApi().getUserChats(sortField, sortOrder, limit, includeClosed));
    }

    public static Api<UserChatsWrapper> getUserChats(String sortField, String sortOrder, Integer limit, boolean includeClosed, String since) {
        return new Api<UserChatsWrapper>(Api.getApi().getUserChatsNext(sortField, sortOrder, limit, includeClosed, since));
    }

    public static Api<UserWrapper> touch(String key, String jwt) {
        return new Api<UserWrapper>(Api.getSimpleApi().touch(key, jwt));
    }

    public static Api<UserChatWrapper> getUserChat(String userChatId) {
        return new Api<UserChatWrapper>(Api.getApi().getUserChat(userChatId));
    }

    public static Api<UserChatWrapper> removeUserChat(String userChatId) {
        return new Api<UserChatWrapper>(Api.getApi().removeUserChat(userChatId));
    }

    public static Api<MessagesWrapper> getMessages(String userChatId, @Nullable String since, Integer limit, String sortOrder) {
        return new Api<MessagesWrapper>(Api.getApi().getMessages(userChatId, since, limit, sortOrder));
    }

    public static Api<UserChatWrapper> createUserChat(String pluginId, String url) {
        return new Api<UserChatWrapper>(Api.getApi().createUserChat(pluginId, url));
    }

    public static Api<UserChatWrapper> createSupportBotUserChat(String supportBotId, String url) {
        return new Api<UserChatWrapper>(Api.getApi().createSupportBotUserChat(supportBotId, url));
    }

    public static Api<MessageWrapper> sendMessage(String userChatId, RequestBody body) {
        return new Api<MessageWrapper>(Api.getApi().sendMessage(userChatId, body));
    }

    public static Api<MessageWrapper> uploadFile(String channelId, String chatId, String requestId, ProgressRequestBody requestBody) {
        return new Api<MessageWrapper>(Api.getMediaApi().uploadFile(channelId, requestBody.getName(), requestBody).flatMap(fileObject -> Api.getApi().sendMessage(chatId, RequestUtils.form().set("requestId", requestId).set("files", Collections.singletonList(fileObject)).create())));
    }

    public static Api<MessageWrapper> closeUserChat(String userChatId, @Nullable String actionId, String requestId) {
        return new Api<MessageWrapper>(Api.getApi().closeUserChat(userChatId, actionId, requestId));
    }

    public static Api<MessageWrapper> reviewUserChat(String userChatId, @Nullable String actionId, String requestId, String review) {
        return new Api<MessageWrapper>(Api.getApi().reviewUserChat(userChatId, actionId, requestId, review));
    }

    public static Api<MessageWrapper> submitButtonAction(String userChatId, @Nullable String buttonId, @Nullable String messageId, @Nullable String requestId) {
        return new Api<MessageWrapper>(Api.getApi().submitButtonAction(userChatId, buttonId, messageId, requestId));
    }

    public static Api<Void> read(String chatId) {
        return new Api<Void>(Api.getApi().read(chatId));
    }

    public static Api<TranslationRepo> getTranslatedMessage(String userChatId, String messageId, String language) {
        return new Api<TranslationRepo>(Api.getApi().getTranslatedMessage(userChatId, messageId, language));
    }

    public static Api<List<Country>> getCountries() {
        return new Api<List<Country>>(Api.getApi().getCountries());
    }

    public static Api<MessageWrapper> updateProfileBot(String userChatId, String messageId, RequestBody requestBody) {
        return new Api<MessageWrapper>(Api.getApi().updateProfileBot(userChatId, messageId, requestBody));
    }

    public static Api<ProfileBotSchemasRepo> getProfileBotSchemas(String pluginId) {
        return new Api<ProfileBotSchemasRepo>(Api.getApi().getProfileBotSchemas(pluginId));
    }

    public static Api<UserWrapper> updateUser(RequestBody body) {
        return new Api<UserWrapper>(Api.getApi().updateUser(body));
    }

    public static Api<Void> closePopUp() {
        return new Api<Void>(Api.getApi().closePopUp());
    }

    public static Api<LoungeChatsWrapper> getLoungeData(String pluginId, @Nullable String url, boolean showClosedChats) {
        return new Api<LoungeChatsWrapper>(Observable.zip(Api.getApi().getLounge(pluginId, url), Api.getApi().getUserChats("updatedAt", "DESC", 50, showClosedChats), LoungeChatsWrapper::new));
    }

    public static Api<AppMessengerUri> getMessengerConnect(String appMessengerName) {
        return new Api<AppMessengerUri>(Api.getApi().getMessengerConnect(appMessengerName));
    }

    public static Api<MessageWrapper> createMarketingSupportBotUserChat(String userChatId, String supportBotId) {
        return new Api<MessageWrapper>(Api.getApi().createMarketingSupportBotUserChat(userChatId, supportBotId));
    }

    public static Api<Void> sendCampaignClickEvent(String marketingId) {
        return new Api<Void>(Api.getApi().campaignClick(marketingId));
    }

    public static Api<Void> sendCampaignViewEvent(String marketingId) {
        return new Api<Void>(Api.getApi().campaignView(marketingId));
    }

    public static Api<Void> oneTimeMsgClick(String marketingId) {
        return new Api<Void>(Api.getApi().oneTimeMsgClick(marketingId));
    }

    public static Api<Void> oneTimeMsgView(String marketingId) {
        return new Api<Void>(Api.getApi().oneTimeMsgView(marketingId));
    }
}

