/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android;

import android.app.Activity;
import android.app.Application;
import android.app.KeyguardManager;
import android.content.Context;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.zoyi.channel.plugin.android.ChannelView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.SkipAttachChannelView;
import com.zoyi.channel.plugin.android.socket.SocketManager;
import com.zoyi.channel.plugin.android.store.GlobalStore;
import com.zoyi.channel.plugin.android.store.TimerStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.L;
import com.zoyi.channel.plugin.android.util.TimeUtils;
import com.zoyi.rx.Observable;
import com.zoyi.rx.Subscription;
import com.zoyi.rx.android.schedulers.AndroidSchedulers;
import com.zoyi.rx.schedulers.Schedulers;
import java.util.HashSet;
import java.util.concurrent.TimeUnit;

public class ActivityLifecycleManager
implements Application.ActivityLifecycleCallbacks {
    private int running = 0;
    @Nullable
    private Subscription workingTimer;
    private HashSet<String> unmanagedActivities = new HashSet();

    public void onActivityCreated(Activity activity, Bundle savedInstanceState) {
    }

    public void onActivityStarted(Activity activity) {
        if (this.isActivityShowWhenLocked(activity)) {
            L.d("ActivityLifecycle:Started:Locked " + activity.getClass().getSimpleName());
            this.unmanagedActivities.add(this.getActivityHash(activity));
        } else {
            FrameLayout root;
            L.d("ActivityLifecycle:Started:Unlocked " + activity.getClass().getSimpleName());
            if (!ChannelUtils.isChannelPluginActivity((Context)activity) && (root = (FrameLayout)activity.findViewById(R.id.channel_io_view)) == null && !activity.getClass().isAnnotationPresent(SkipAttachChannelView.class)) {
                root = new FrameLayout((Context)activity);
                root.setClipChildren(false);
                root.setClipToPadding(false);
                root.setFitsSystemWindows(true);
                root.setId(R.id.channel_io_view);
                try {
                    root.addView((View)new ChannelView((Context)activity));
                    activity.addContentView((View)root, (ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                }
                catch (Exception e) {
                    L.e(e.getMessage());
                }
            }
            GlobalStore.get().topActivity.set(activity);
            if (++this.running == 1 && GlobalStore.get().bootState.get().booleanValue()) {
                SocketManager.connect();
                this.attachTimestampTimer();
            }
        }
    }

    public void onActivityResumed(Activity activity) {
        L.d("ActivityLifecycle:Resumed: " + activity.getClass().getSimpleName());
        GlobalStore.get().topActivity.set(activity);
    }

    public void onActivityPaused(Activity activity) {
        L.d("ActivityLifecycle:Paused: " + activity.getClass().getSimpleName());
        if (GlobalStore.get().topActivity.get() == activity) {
            GlobalStore.get().topActivity.set(null);
        }
    }

    public void onActivityStopped(Activity activity) {
        if (this.unmanagedActivities.contains(this.getActivityHash(activity))) {
            L.d("ActivityLifecycle:Stopped:Locked " + activity.getClass().getSimpleName() + " " + this.running);
            this.unmanagedActivities.remove(this.getActivityHash(activity));
        } else {
            L.d("ActivityLifecycle:Stopped:Unlocked " + activity.getClass().getSimpleName() + " " + this.running + " -> " + (this.running - 1));
            if (GlobalStore.get().topActivity.get() == activity) {
                GlobalStore.get().topActivity.set(null);
            }
            if (--this.running == 0) {
                SocketManager.disconnect();
                this.detachTimestampTimer();
            }
        }
    }

    public void onActivitySaveInstanceState(Activity activity, Bundle outState) {
    }

    public void onActivityDestroyed(Activity activity) {
    }

    public void attachTimestampTimer() {
        this.detachTimestampTimer();
        this.workingTimer = Observable.interval((long)60L, (TimeUnit)TimeUnit.SECONDS).onBackpressureBuffer().subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).subscribe(l -> TimerStore.get().now.set(TimeUtils.getCurrentTime()));
    }

    public void detachTimestampTimer() {
        if (this.workingTimer != null) {
            if (!this.workingTimer.isUnsubscribed()) {
                this.workingTimer.unsubscribe();
            }
            this.workingTimer = null;
        }
    }

    private boolean isActivityShowWhenLocked(Activity activity) {
        KeyguardManager keyguardManager = (KeyguardManager)activity.getSystemService("keyguard");
        if (keyguardManager != null) {
            if (Build.VERSION.SDK_INT >= 22) {
                return keyguardManager.isKeyguardLocked();
            }
            return keyguardManager.inKeyguardRestrictedInputMode();
        }
        return false;
    }

    private String getActivityHash(Activity activity) {
        return String.format("%s:%s", activity.getClass().getSimpleName(), activity.hashCode());
    }
}

