package com.zoyi.channel.plugin.android.store.state;

import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.UpdatableEntity;
import com.zoyi.channel.plugin.android.store.callback.MapStateCallback;
import com.zoyi.channel.plugin.android.util.CompareUtils;

public class EntityMapState<E extends Entity> extends MapState<String, E> {

  public EntityMapState() {
    super(Entity::getId);
  }

  public EntityMapState(MapStateCallback<String, E> callback) {
    super(callback);
  }

  @Override
  protected boolean canUpdate(E oldbie, E newbie) {
    if (oldbie instanceof UpdatableEntity && newbie instanceof UpdatableEntity) {
      return CompareUtils.compare(((UpdatableEntity) oldbie).getUpdatedAt(), ((UpdatableEntity) newbie).getUpdatedAt()) <= 0;
    }
    return true;
  }
}
