package com.zoyi.channel.plugin.android.selector;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.*;
import com.zoyi.channel.plugin.android.store.*;
import com.zoyi.channel.plugin.android.store.binder.*;
import com.zoyi.channel.plugin.android.store.state.*;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.rx.functions.Action1;

public class LoungeSelector {

  public static Binder bindPreviewState(Action1<PreviewState> action1) {
    State<Plugin> pluginState = PluginStore.get().pluginState;

    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    State<FetchState> userChatsFetchState = UserChatStore.get().userChatsFetchState;

    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
    State<FetchState> supportBotFetchState = SupportBotStore.get().supportBotFetchState;

    State<User> userState = UserStore.get().user;

    BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;

    return new Binder7<>(
        userChatsFetchState,
        userChatsState,
        supportBotFetchState,
        supportBotState,
        pluginState,
        userState,
        showClosedChatsState
    ).bind((userChatFetch, userChats, supportBotFetch, supportBotEntity, plugin, user, showClosedChat) -> {
      // if user chat is loading, keep going
      if (userChatFetch == FetchState.LOADING) {
        action1.call(PreviewState.LOADING);
        return;
      }

      // if user chat load failed, show error
      if (userChatFetch == FetchState.FAILED) {
        action1.call(PreviewState.FAILED);
        return;
      }

      boolean hasActiveChats = false;
      int visibleChatsCount = 0;

      if (userChats != null) {
        for (UserChat userChat : userChats.values()) {
          if (!userChat.isStateClosed() && !userChat.isStateRemoved()) {
            hasActiveChats = true;

            if (visibleChatsCount < Const.LOUNGE_PREVIEW_MAX_CHATS) {
              visibleChatsCount++;
            }
          }
        }
      }

      // if user chat fetch is complete and is not empty, show direct
      if (hasActiveChats) {
        action1.call(PreviewState.CHATS);
        return;
      }

      // if support bot is loading, show loading view
      if (supportBotFetch == FetchState.LOADING) {
        action1.call(PreviewState.LOADING);
        return;
      }

      // if support bot is failed, show failed
      if (supportBotFetch == FetchState.FAILED) {
        action1.call(PreviewState.FAILED);
        return;
      }

      // if support bot is not empty, show support bot step message
      if (supportBotEntity != null && supportBotEntity.getStep() != null && supportBotEntity.getStep().getPlainText() != null) {
        action1.call(PreviewState.WELCOME);
        return;
      }

      if (plugin != null && user != null) {
        action1.call(PreviewState.WELCOME);
        return;
      }

      action1.call(PreviewState.FAILED);
    });
  }

  public static Binder bindWelcomeMessage(Action1<String> action1) {
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
    EnumState<CHLocale> localeState = SettingsStore.get().locale;

    return new Binder3<>(pluginState, supportBotState, localeState).bind((plugin, supportBotEntry, locale) -> {
      if (supportBotEntry != null && supportBotEntry.getStep() != null && supportBotEntry.getStep().getPlainText() != null) {
        action1.call(supportBotEntry.getStep().getPlainText());
      } else if (plugin != null) {
        action1.call(MessageUtils.createWelcomeMessage(plugin, locale));
      } else {
        action1.call("");
      }
    });
  }
}
