/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.model.rest;

import android.graphics.Point;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.model.entity.Entity;
import com.zoyi.channel.plugin.android.model.entity.FileMeta;
import com.zoyi.channel.plugin.android.model.entity.Previewable;
import com.zoyi.channel.plugin.android.util.UriUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import java.util.Locale;

public class File
implements Entity,
FileMeta,
Previewable {
    private static final int TYPE_VIDEO = 0;
    private static final int TYPE_IMAGE = 1;
    private static final int TYPE_OTHER = 2;
    private String id;
    @Nullable
    private String type;
    @Nullable
    private String name;
    @Nullable
    private Long size;
    @Nullable
    private String contentType;
    @Nullable
    private Integer width;
    @Nullable
    private Integer height;
    @Nullable
    private String bucket;
    @Nullable
    private String key;
    @Nullable
    private Boolean thumb;
    @Nullable
    private String previewKey;
    private Double duration;
    public static final String CLASSNAME = "file";

    @NonNull
    public String getType() {
        if (this.type == null) {
            return "";
        }
        return this.type;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getName() {
        return this.name;
    }

    public long getSize() {
        if (this.size == null) {
            return 0L;
        }
        return this.size;
    }

    @Override
    @NonNull
    public Integer getWidth() {
        if (this.width == null) {
            return 0;
        }
        return this.width;
    }

    @Override
    @NonNull
    public Integer getHeight() {
        if (this.height == null) {
            return 0;
        }
        return this.height;
    }

    private String getBucketCdn() {
        return UriUtils.getCloudFrontUrl(this.bucket);
    }

    @Nullable
    public String getKey() {
        return this.key;
    }

    public boolean isThumb() {
        if (this.thumb == null) {
            return true;
        }
        return this.thumb;
    }

    @Nullable
    public String getPreviewKey() {
        if (this.previewKey == null) {
            return this.key;
        }
        return this.previewKey;
    }

    public double getDuration() {
        if (this.duration == null) {
            return 0.0;
        }
        return this.duration;
    }

    @Override
    public String getUrl() {
        return String.format("%s/%s", this.getBucketCdn(), this.key);
    }

    @Nullable
    public String getThumbnailURL(Point previewImageSize) {
        if (this.isThumb()) {
            return String.format(Locale.US, "%s/thumb/%dx%d,cover/%s", this.getBucketCdn(), previewImageSize.x, previewImageSize.y, this.getPreviewKey());
        }
        return this.getUrl();
    }

    @Nullable
    public String getExtension() {
        return FilenameUtils.getExtension(this.getName());
    }

    public boolean isImage() {
        return "image".equals(this.getType());
    }

    public boolean isVideo() {
        return "video".equals(this.getType());
    }

    public boolean isPreviewable() {
        return this.isImage() || this.isVideo();
    }
}

