/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.layout;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.View;
import android.widget.LinearLayout;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.util.Initializer;

public class MaxSizeLinearLayout
extends LinearLayout {
    private int maxWidthSize;

    public MaxSizeLinearLayout(Context context) {
        super(context);
    }

    public MaxSizeLinearLayout(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public MaxSizeLinearLayout(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Initializer
    protected void init(Context context, @Nullable AttributeSet attrs) {
        if (attrs != null) {
            TypedArray typedArray = context.getTheme().obtainStyledAttributes(attrs, R.styleable.MaxSizeLinearLayout, 0, 0);
            try {
                this.maxWidthSize = typedArray.getDimensionPixelSize(R.styleable.MaxSizeLinearLayout_ch_max_width, this.maxWidthSize);
            }
            finally {
                typedArray.recycle();
            }
        }
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int popupWidth = View.MeasureSpec.getSize((int)widthMeasureSpec);
        if (this.maxWidthSize < popupWidth) {
            popupWidth = this.maxWidthSize;
        }
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)popupWidth, (int)View.MeasureSpec.getMode((int)widthMeasureSpec));
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }
}

