/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.push_bot;

import android.app.Activity;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.ChannelApiManager;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.model.wrapper.PushBotReachRepo;
import com.zoyi.channel.plugin.android.selector2.PushSelector;
import com.zoyi.channel.plugin.android.store2.InAppPushStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.rx.Observable;
import java.util.concurrent.TimeUnit;

public class PushBotManager {
    public static Observable<PushBotReachRepo> handlePushBot(@Nullable EventRepo eventRepo) {
        if (eventRepo != null && eventRepo.getPushBotCandidates() != null) {
            return Observable.from(eventRepo.getPushBotCandidates()).filter(PushSelector::canTryReach).toList().flatMap(Observable::from).flatMap(pushBot -> Observable.just((Object)pushBot).delay((long)pushBot.getTriggerDelay().intValue(), TimeUnit.SECONDS)).concatMap(pushBot -> ChannelApiManager.get().reachPushBot(pushBot.getId())).filter(PushBotReachRepo::isReach).firstOrDefault(null);
        }
        return Observable.empty();
    }

    public static void doPushBotAction(@NonNull PushBotReachRepo pushBotReachRepo, @Nullable Activity topActivity) {
        if (pushBotReachRepo.isValid()) {
            PushBotItem pushBotItem = PushBotItem.newInstance(pushBotReachRepo.getPushBot(), pushBotReachRepo.getPushBotVariant(), topActivity);
            if (!pushBotReachRepo.isOriginState()) {
                pushBotReachRepo.set();
                InAppPushStore.get().pushItem.set(pushBotItem);
            }
            PushBotStore.get().pushBots.upsert(pushBotItem);
        }
    }
}

