/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.PushBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.activity.chat.viewholder.ContentMessageHolder;
import com.zoyi.channel.plugin.android.model.MessageButton;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.rest.Message;
import com.zoyi.channel.plugin.android.model.rest.PreviewThumb;
import java.util.Collections;

public class PushBotMessageHolder
extends ContentMessageHolder {
    @Nullable
    private PushBotItem pushBotItem;

    public static PushBotMessageHolder newInstance(ViewGroup parent, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        return new PushBotMessageHolder(PushBotMessageHolder.getItemView(parent, MessageType.PUSH_BOT), MessageType.PUSH_BOT, onMessageContentClickListener);
    }

    private PushBotMessageHolder(View itemView, MessageType messageType, @Nullable OnMessageContentClickListener onMessageContentClickListener) {
        super(itemView, messageType, onMessageContentClickListener);
    }

    public void bind(PushBotMessageItem item) {
        Message message = item.getMessage();
        this.pushBotItem = item.getPushBotItem();
        super.bind(message, MessageType.PUSH_BOT, false);
        this.setHostMessageText((CharSequence)message.getFormattedSpanMessage(), false);
        String attachment = this.pushBotItem.getAttachment();
        if (attachment != null) {
            switch (attachment) {
                case "button": {
                    if (this.pushBotItem.getButtonTitle() == null || this.pushBotItem.getButtonRedirectUrl() == null) break;
                    MessageButton pushBotMessageButton = new MessageButton(this.pushBotItem.getButtonTitle(), this.pushBotItem.getButtonRedirectUrl());
                    this.setMessageButtons(Collections.singletonList(pushBotMessageButton));
                    break;
                }
                case "image": {
                    PreviewThumb imageThumb = this.pushBotItem.getImageThumb();
                    String imageRedirectUrl = this.pushBotItem.getImageRedirectUrl();
                    if (imageThumb == null) break;
                    if (imageRedirectUrl != null) {
                        this.setLinkableImage(imageThumb);
                        break;
                    }
                    this.setImage(imageThumb);
                }
            }
        }
    }

    @Override
    protected void onImageClick() {
        if (this.onMessageContentClickListener != null && this.pushBotItem != null) {
            this.onMessageContentClickListener.onLocalImageClick(this.pushBotItem.getImageThumb());
        }
    }

    @Override
    protected void onLinkableImageClick() {
        if (this.onMessageContentClickListener != null && this.pushBotItem != null) {
            this.onMessageContentClickListener.onRedirectContentsClick(this.pushBotItem.getImageRedirectUrl());
        }
    }
}

