package com.zoyi.channel.plugin.android.selector2;

import android.support.annotation.Nullable;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.rest.Channel;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.MessengersRepo;
import com.zoyi.channel.plugin.android.store2.ChannelStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.TimerStore;
import com.zoyi.channel.plugin.android.store2.TypingStore;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder1;
import com.zoyi.channel.plugin.android.store2.binder.Binder2;
import com.zoyi.channel.plugin.android.store2.binder.Binder3;
import com.zoyi.channel.plugin.android.store2.binder.Binder4;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EnumState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;
import com.zoyi.rx.functions.Action4;

public class ChannelSelector {

  public static Binder1 bindChannel(Action1<Channel> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;

    return new Binder1<>(channelState).bind(channel -> {
      if (channel != null) {
        action1.call(channel);
      }
    });
  }

  public static Binder bindAcceptAction(Action1<Boolean> action1) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Long> nowState = TimerStore.get().now;
    BooleanState typingState = TypingStore.get().typingState;

    return new Binder3<>(channelState, nowState, typingState).bind((channel, now, isTyping) -> {
      action1.call(shouldAcceptAction(channel, now, isTyping));
    });
  }

  static boolean shouldAcceptAction(@Nullable Channel channel, @Nullable Long now, Boolean isTyping) {
    if (isTyping != null && isTyping) {
      return true;
    } else if (channel != null && now != null) {
      return Const.AWAY_OPTION_ACTIVE.equals(channel.getAwayOption()) || ChannelUtils.getMinutesLeftToWork(channel, now) == 0;
    }
    return false;
  }

  public static Binder2 bindWaterMark(Action2<Channel, Plugin> action2) {
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Plugin> pluginState = PluginStore.get().pluginState;

    return new Binder2<>(channelState, pluginState).bind((channel, plugin) -> {
      if (channel != null && plugin != null) {
        action2.call(channel, plugin);
      }
    });
  }

  public static Binder bindIntegrations(Action4<FetchState, Channel, Plugin, MessengersRepo> action4) {
    EnumState<FetchState> messengersFetchState = ChannelStore.get().messengersFetchState;
    State<Channel> channelState = ChannelStore.get().channelState;
    State<Plugin> pluginState = PluginStore.get().pluginState;
    State<MessengersRepo> messengersState = ChannelStore.get().messengers;

    return new Binder4<>(messengersFetchState, channelState, pluginState, messengersState).bind(action4);
  }
}
