/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.wrapper.UserChatsWrapper;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.network.RetrofitException;
import com.zoyi.channel.plugin.android.store2.BotStore;
import com.zoyi.channel.plugin.android.store2.ManagerStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;

public class UserChatAction {
    public static void fetchUserChats(boolean showClosedChats) {
        Store2.getInstance(UserChatStore.class).userChatsFetchState.set(FetchState.LOADING);
        Api.getUserChats("updatedAt", "DESC", 50, showClosedChats).runBy(ActionType.REQUEST_USER_CHATS).cancelBy(ActionType.SOCKET_DISCONNECTED, ActionType.MESSENGER_CLOSED, ActionType.SHUTDOWN).run(new RestSubscriber<UserChatsWrapper>(){

            @Override
            public void onError(RetrofitException error) {
                Store2.getInstance(UserChatStore.class).userChatsFetchState.set(FetchState.FAILED);
            }

            @Override
            public void onSuccess(@NonNull UserChatsWrapper userChatsWrapper) {
                userChatsWrapper.set();
                Store2.getInstance(BotStore.class).bots.add(userChatsWrapper.getBots());
                Store2.getInstance(ManagerStore.class).managers.add(userChatsWrapper.getManagers());
                Store2.getInstance(UserChatStore.class).messages.set(userChatsWrapper.getMessages());
                Store2.getInstance(UserChatStore.class).sessions.set(userChatsWrapper.getSessions());
                Store2.getInstance(UserChatStore.class).userChats.set(userChatsWrapper.getUserChats());
                Store2.getInstance(UserChatStore.class).userChatsFetchState.set(FetchState.COMPLETE);
            }
        });
    }
}

