package com.zoyi.channel.plugin.android.activity.chat.viewholder;

import android.support.annotation.Nullable;
import android.view.View;
import android.view.ViewGroup;
import com.zoyi.channel.plugin.android.activity.chat.listener.OnMessageContentClickListener;
import com.zoyi.channel.plugin.android.activity.chat.model.SupportBotMessageItem;
import com.zoyi.channel.plugin.android.activity.chat.type.MessageType;
import com.zoyi.channel.plugin.android.global.Const;

/**
 * Created by mika on 2018. 10. 26..
 */

public class SupportBotMessageHolder extends ContentMessageHolder {

  public static SupportBotMessageHolder newInstance(
      ViewGroup parent,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    return new SupportBotMessageHolder(
        getItemView(parent, MessageType.SUPPORT_BOT),
        MessageType.SUPPORT_BOT,
        onMessageContentClickListener);
  }

  private SupportBotMessageHolder(
      View itemView,
      MessageType messageType,
      @Nullable OnMessageContentClickListener onMessageContentClickListener) {
    super(itemView, messageType, onMessageContentClickListener);
  }

  public void bind(SupportBotMessageItem item, boolean isLastMessage) {
    super.bind(item.getMessage(), MessageType.SUPPORT_BOT, false);
    setHostMessageText(item.getMessage().getFormattedSpanMessage(), false);

    if (item.getStep() != null) {
      setImage(item.getStep().getImageThumb());
    }

    if (item.getButtons() != null && isLastMessage) {
      setAction(Const.ACTION_TYPE_SUPPORT_BOT, item.getButtons());
    }
  }
}
