package com.zoyi.channel.plugin.android.selector2;

import com.zoyi.channel.plugin.android.CHLocale;
import com.zoyi.channel.plugin.android.activity.lounge.enumerate.PreviewState;
import com.zoyi.channel.plugin.android.enumerate.FetchState;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.PushBotItem;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.entity.Guest;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.rest.UserChat;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.store2.PushBotStore;
import com.zoyi.channel.plugin.android.store2.SettingsStore;
import com.zoyi.channel.plugin.android.store2.SupportBotStore;
import com.zoyi.channel.plugin.android.store2.UserChatStore;
import com.zoyi.channel.plugin.android.store2.base.Store2;
import com.zoyi.channel.plugin.android.store2.binder.Binder;
import com.zoyi.channel.plugin.android.store2.binder.Binder4;
import com.zoyi.channel.plugin.android.store2.binder.Binder8;
import com.zoyi.channel.plugin.android.store2.state.BooleanState;
import com.zoyi.channel.plugin.android.store2.state.EntityMapState;
import com.zoyi.channel.plugin.android.store2.state.EnumState;
import com.zoyi.channel.plugin.android.store2.state.State;
import com.zoyi.channel.plugin.android.util.MessageUtils;
import com.zoyi.rx.functions.Action1;
import com.zoyi.rx.functions.Action2;

public class LoungeSelector {

  public static Binder bindPreviewState(Action2<PreviewState, Integer> action2) {
    State<Plugin> pluginState = PluginStore.get().pluginState;

    EntityMapState<UserChat> userChatsState = UserChatStore.get().userChats;
    State<FetchState> userChatsFetchState = UserChatStore.get().userChatsFetchState;

    EntityMapState<PushBotItem> pushBotItemsState = PushBotStore.get().pushBots;

    State<SupportBotEntry> supportBotState = SupportBotStore.get().supportBotState;
    State<FetchState> supportBotFetchState = SupportBotStore.get().supportBotFetchState;

    State<Guest> guestState = GuestStore.get().guest;

    BooleanState showClosedChatsState = SettingsStore.get().showClosedChat;

    return new Binder8<>(
        userChatsFetchState,
        userChatsState,
        pushBotItemsState,
        supportBotFetchState,
        supportBotState,
        pluginState,
        guestState,
        showClosedChatsState
    ).bind((userChatFetch, userChats, pushBotItems, supportBotFetch, supportBotEntity, plugin, guest, showClosedChat) -> {
      // if user chat is loading, keep going
      if (userChatFetch == FetchState.LOADING) {
        action2.call(PreviewState.LOADING, 0);
        return;
      }

      // if user chat load failed, show error
      if (userChatFetch == FetchState.FAILED) {
        action2.call(PreviewState.FAILED, 0);
        return;
      }

      boolean hasActiveChats = false;
      int visibleChatsCount = 0;
      int invisibleChatsCount = 0;

      for (PushBotItem pushBotItem : pushBotItems.values()) {
        if (pushBotItem.isActive()) {
          hasActiveChats = true;
          visibleChatsCount++;
        }
      }

      if (userChats != null) {
        for (UserChat userChat : userChats.values()) {
          if (!userChat.isStateClosed() && !userChat.isStateRemoved()) {
            hasActiveChats = true;

            if (visibleChatsCount < Const.LOUNGE_PREVIEW_MAX_CHATS) {
              visibleChatsCount++;
            } else {
              invisibleChatsCount++;
            }
          } else if (userChat.isStateClosed()) {
            invisibleChatsCount++;
          }
        }
      }

      // if user chat fetch is complete and is not empty, show direct
      if (hasActiveChats) {
        action2.call(PreviewState.CHATS, invisibleChatsCount);
        return;
      }

      // if support bot is loading, show loading view
      if (supportBotFetch == FetchState.LOADING) {
        action2.call(PreviewState.LOADING, 0);
        return;
      }

      // if support bot is failed, show failed
      if (supportBotFetch == FetchState.FAILED) {
        action2.call(PreviewState.FAILED, 0);
        return;
      }

      // if support bot is not empty, show support bot step message
      if (supportBotEntity != null && supportBotEntity.getStep() != null && supportBotEntity.getStep().getMessage() != null) {
        action2.call(PreviewState.WELCOME, invisibleChatsCount);
        return;
      }

      if (plugin != null && guest != null) {
        action2.call(PreviewState.WELCOME, invisibleChatsCount);
        return;
      }

      action2.call(PreviewState.FAILED, 0);
    });
  }

  public static Binder bindWelcomeMessage(Action1<String> action1) {
    State<Plugin> pluginState = Store2.getInstance(PluginStore.class).pluginState;
    State<SupportBotEntry> supportBotState = Store2.getInstance(SupportBotStore.class).supportBotState;
    State<Guest> guestState = Store2.getInstance(GuestStore.class).guest;
    EnumState<CHLocale> localeState = SettingsStore.get().locale;

    return new Binder4<>(pluginState, supportBotState, guestState, localeState).bind((plugin, supportBotEntry, guest, locale) -> {
      if (supportBotEntry != null && supportBotEntry.getStep() != null && supportBotEntry.getStep().getMessage() != null) {
        action1.call(supportBotEntry.getStep().getMessage());
      } else if (plugin != null && guest != null) {
        action1.call(MessageUtils.createWelcomeMessage(plugin, guest, locale));
      } else {
        action1.call("");
      }
    });
  }
}
