package com.zoyi.channel.plugin.android.activity.chat3.manager.chat;

import android.support.annotation.Nullable;

import java.util.HashMap;

public class ChatManager {

  private static boolean initialized = false;

  private static ChatManagerImpl emptyChatManager = new EmptyChatManager();

  private static HashMap<String, ChatManagerImpl> chatManagers = new HashMap<>();

  public static ChatManagerImpl get(@Nullable String chatId) {
    if (initialized && chatManagers != null && chatId != null) {
      ChatManagerImpl chatManager = chatManagers.get(chatId);

      if (chatManager != null) {
        return chatManager;
      }

      ChatManagerImpl newChatManager = new RealChatManager(chatId);
      chatManagers.put(chatId, newChatManager);

      return newChatManager;
    }
    return emptyChatManager;
  }

  public static void initialize() {
    initialized = true;
  }

  public static void release() {
    initialized = false;

    if (chatManagers != null) {
      for (ChatManagerImpl chatManager : chatManagers.values()) {
        if (chatManager != null) {
          chatManager.release();
        }
      }
      chatManagers.clear();
    }
  }
}
