package com.zoyi.channel.plugin.android.util;

import android.content.Context;
import org.json.JSONArray;
import org.json.JSONObject;

import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * Created by jerry on 2018. 3. 27..
 */

public class AssetUtils {

  private static final String EMOJI_FILE = "emojis.min.json";

  private static final String KEY_EMOJI_NAME = "n";
  private static final String KEY_EMOJI_CONTENT = "c";

  private static Map<String, String> emojiMap;

  public static String getEmoji(Context context, String key) {
    if (emojiMap != null) {
      return emojiMap.get(key);
    }

    emojiMap = new ConcurrentHashMap<>();

    try {
      InputStream inputStream = context.getAssets().open(EMOJI_FILE);
      int size = inputStream.available();
      byte[] buffer = new byte[size];

      inputStream.read(buffer);
      inputStream.close();

      JSONObject emojiJson = new JSONObject(new String(buffer, "UTF-8"));

      Iterator<String> emojiKeys = emojiJson.keys();
      while (emojiKeys.hasNext()) {
        String category = emojiKeys.next();

        JSONArray emojiCategory = emojiJson.getJSONArray(category);

        for (int i = 0; i < emojiCategory.length(); i++) {
          String emojiKey = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_NAME);
          String emojiValue = emojiCategory.getJSONObject(i).getString(KEY_EMOJI_CONTENT);

          if (emojiKey != null && emojiValue != null) {
            emojiMap.put(emojiKey, emojiValue);
          }
        }
      }

    } catch (Exception ignored) { }

    return emojiMap.get(key);
  }
}
