package com.zoyi.channel.plugin.android.network;

import android.support.annotation.Nullable;

import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.model.SupportBotEntry;
import com.zoyi.channel.plugin.android.model.rest.Country;
import com.zoyi.channel.plugin.android.model.wrapper.*;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import com.zoyi.retrofit2.http.*;
import com.zoyi.rx.Observable;

import java.util.List;
import java.util.Map;

/**
 * Created by mika on 2016. 1. 20..
 */
public interface ChannelApi {
  @GET("packages/{packageId}/versions/latest")
  Observable<PackageWrapper> getLastestPackage(@Path("packageId") String packageId, @Query("from") String from);

  @Headers({"Content-Type: application/json"})
  @POST("/app/plugins/{key}/boot/v2")
  Observable<PluginWrapper> bootV2(@HeaderMap Map<String, String> headers, @Body RequestBody body,  @Nullable @Path("key") String key);

  @GET("/app/plugins/{pluginId}")
  Observable<PluginWrapper> getPlugin(@Path("pluginId") String pluginId);

  @GET("/app/channels")
  Observable<ChannelWrapper> getChannel();

  @POST("/app/guests/touch")
  Observable<GuestWrapper> touch();

  @POST("/app/guests/touch")
  Observable<GuestWrapper> touch(@Header(Const.ACCEPT_LANGUAGE) String language);

  @GET("/app/user_chats")
  Observable<UserChatsWrapper> getUserChats(@Query("sortField") String sortField, @Query("sortOrder") String sortOrder, @Query("limit") Integer limit, @Query("includeClosed") boolean includeClosed);

  @GET("/app/user_chats/{userChatId}")
  Observable<UserChatWrapper> getUserChat(@Path("userChatId") String userChatId);

  @GET("/app/user_chats/{userChatId}/messages")
  Observable<MessagesWrapper> getMessages(@Path("userChatId") String userChatId, @Query("since") String since, @Query("limit") Integer limit, @Query("sortOrder") String sortOrder);

  @POST("/app/plugins/{pluginId}/user_chats")
  Observable<UserChatWrapper> createUserChat(@Path("pluginId") String pluginId);

  @PUT("/app/user_chats/{userChatId}/messages/read")
  Observable<Void> read(@Path("userChatId") String userChatId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/user_chats/{userChatId}/messages")
  Observable<MessageWrapper> sendMessage(@Path("userChatId") String userChatId, @Body RequestBody body);

  @Multipart
  @POST("/app/user_chats/{userChatId}/messages/file")
  Observable<MessageWrapper> uploadFile(@Path("userChatId") String userChatId, @Part MultipartBody.Part file, @Part("requestId") RequestBody requestId);

  @Headers({"Content-Type: application/json"})
  @POST("app/device_tokens")
  Observable<Void> sendToken(@Body RequestBody body);

  @Headers({"Content-Type: application/json"})
  @DELETE("app/device_tokens/{platform}/{key}")
  Observable<Void> deleteToken(@Header("X-Guest-Jwt") String jwt, @Path("platform") String platform, @Path("key") String key);

  @Headers({"Content-Type: application/json"})
  @PUT("app/user_chats/{userChatId}/remove")
  Observable<Void> removeUserChat(@Path("userChatId") String userChatId);

  @PUT("app/user_chats/{userChatId}/close")
  Observable<MessageWrapper> closeUserChat(@Path("userChatId") String userChatId, @Nullable @Query("formId") String formId, @Query("requestId") String requestId);

  @FormUrlEncoded
  @PUT("app/user_chats/{userChatId}/review")
  Observable<MessageWrapper> reviewUserChat(@Path("userChatId") String userChatId, @Nullable @Query("formId") String formId, @Field("review") String review, @Query("requestId") String requestId);

  @GET("/available/countries")
  Observable<List<Country>> getCountries();

  @POST("/app/plugins/{pluginId}/events/v2")
  Observable<EventRepo> trackEvent(@Path("pluginId") String pluginId, @Body RequestBody body);

  @GET("/app/channels/following_managers")
  Observable<ManagersWrapper> getFollowingManagers();

  @POST("/app/user_chats/{userChatId}/plugins/{pluginId}/profile_bot")
  Observable<Void> requestProfileBot(@Path("userChatId") String userChatId, @Path("pluginId") String pluginId);

  @Headers({"Content-Type: application/json"})
  @POST("/app/messages/{messageId}/profile_bot")
  Observable<MessageWrapper> updateProfileBot(@Path("messageId") String messageId, @Body RequestBody requestBody);

  @GET("app/messages/{messageId}/translate")
  Observable<TranslationRepo> getTranslatedMessage(@Path("messageId") String messageId, @Query("language") String language);

  @GET("/app/plugins/{pluginId}/support_bot")
  Observable<SupportBotEntry> getSupportBot(@Path("pluginId") String pluginId);

  @POST("app/support_bots/{supportBotId}/user_chats")
  Observable<UserChatWrapper> createSupportBotUserChat(@Path("supportBotId") String supportBotId);

  @POST("/app/user_chats/{userChatId}/support_bot/buttons/{buttonId}")
  Observable<MessageWrapper> submitButtonAction(@Path("userChatId") String userChatId, @Nullable @Path("buttonId") String buttonId, @Nullable @Query("actionId") String messageId, @Nullable @Query("requestId") String requestId);

  @PUT("app/user_chats/{userChatId}/messages/receive")
  Observable<Void> receivePushNotification(@Path("userChatId") String userChatId);

  @POST("/app/nudges/{pushBotId}/reach")
  Observable<PushBotReachRepo> reachPushBot(@Path("pushBotId") String pushBotId);

  @POST("/app/nudges/{pushBotId}/user_chats")
  Observable<UserChatWrapper> createPushBotUserChat(@Path("pushBotId") String pushBotId);

  @POST("/app/user_chats/{userChatId}/nudge/keep")
  Observable<MessageWrapper> keepPushBot(@Path("userChatId") String userChatId);

  @GET("/app/plugins/{pluginId}/profile_bot_schemas")
  Observable<ProfileBotSchemasRepo> getProfileBotSchemas(@Path("pluginId") String pluginId);

  @PUT("/app/guests")
  Observable<GuestWrapper> updateGuest(@Body RequestBody body);

  @GET("/app/channels/messengers")
  Observable<MessengersRepo> getMessengers();
}
