/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.action;

import android.app.Activity;
import android.content.Context;
import android.support.annotation.NonNull;
import com.zoyi.channel.plugin.android.enumerate.ActionType;
import com.zoyi.channel.plugin.android.global.Api;
import com.zoyi.channel.plugin.android.model.rest.Event;
import com.zoyi.channel.plugin.android.model.rest.Plugin;
import com.zoyi.channel.plugin.android.model.wrapper.EventRepo;
import com.zoyi.channel.plugin.android.network.RestSubscriber;
import com.zoyi.channel.plugin.android.push_bot.PushBotManager;
import com.zoyi.channel.plugin.android.store2.GlobalStore;
import com.zoyi.channel.plugin.android.store2.GuestStore;
import com.zoyi.channel.plugin.android.store2.PluginStore;
import com.zoyi.channel.plugin.android.util.ChannelUtils;
import com.zoyi.channel.plugin.android.util.ListUtils;
import com.zoyi.channel.plugin.android.util.ObjectUtils;
import com.zoyi.channel.plugin.android.util.RequestUtils;
import com.zoyi.okhttp3.RequestBody;
import java.util.HashMap;

public class EventAction {
    public static void trackPageView() {
        HashMap<String, Object> property = new HashMap<String, Object>();
        Activity activity = GlobalStore.get().topActivity.get();
        if (activity != null && !ChannelUtils.isChannelPluginActivity((Context)activity)) {
            property.put("url", activity.getClass().getSimpleName());
        }
        EventAction.track(new Event("PageView", property));
    }

    public static void track(Event event) {
        Plugin plugin = PluginStore.get().pluginState.get();
        if (plugin != null && plugin.getId() != null) {
            RequestBody body = RequestUtils.form().set("event", ObjectUtils.toMap(event)).set("guest", ObjectUtils.toMap(GuestStore.get().guest)).create();
            Api.trackEvent(plugin.getId(), body).cancelBy(ActionType.SHUTDOWN).run(new RestSubscriber<EventRepo>(){

                @Override
                public void onSuccess(@NonNull EventRepo eventRepo) {
                    if (ListUtils.hasItems(eventRepo.getPushBotCandidates())) {
                        PushBotManager.reachPushBots(eventRepo.getPushBotCandidates());
                    }
                }
            });
        }
    }
}

