/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.view.popup;

import android.content.Context;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.widget.TextView;
import com.zoyi.channel.plugin.android.R;
import com.zoyi.channel.plugin.android.model.etc.PushItem;
import com.zoyi.channel.plugin.android.view.popup.BasePushView;

public class PopupPushView
extends BasePushView {
    private TextView textPopupTitle;
    private TextView textPushBotPopupButton;

    public PopupPushView(@NonNull Context context) {
        super(context);
    }

    public PopupPushView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
    }

    public PopupPushView(@NonNull Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
    }

    @Override
    protected int getLayoutId() {
        return R.layout.ch_plugin_view_popup;
    }

    @Override
    protected void init(Context context) {
        super.init(context);
        this.textPushBotPopupButton = (TextView)this.root.findViewById(R.id.ch_text_popup_button);
        this.textPopupTitle = (TextView)this.root.findViewById(R.id.ch_text_popup_title);
    }

    @Override
    public void show(PushItem pushItem) {
        super.show(pushItem);
        this.root.setOnClickListener(view -> {});
    }

    @Override
    public void resetView() {
        super.resetView();
        this.textPopupTitle.setText((CharSequence)"");
        this.textPopupTitle.setVisibility(8);
    }

    @Override
    protected int getDefaultTextMaxLine() {
        return 8;
    }

    @Override
    protected int getAttachmentTextMaxLine() {
        return 5;
    }

    @Override
    protected void bindTitle(PushItem pushItem) {
        if (this.textPopupTitle != null) {
            if (pushItem.getTitle() != null && !pushItem.getTitle().isEmpty()) {
                this.textPopupTitle.setVisibility(0);
                this.textPopupTitle.setText((CharSequence)pushItem.getTitle());
            } else {
                this.textPopupTitle.setVisibility(8);
            }
        }
    }

    @Override
    protected void bindContent(PushItem pushItem) {
        if (this.textPopupMessage != null) {
            this.textPopupMessage.setMaxLines(this.getDefaultTextMaxLine());
            this.textPopupMessage.setText((CharSequence)pushItem.getFormattedSpanMessage());
        }
    }

    @Override
    protected void bindButton() {
        if (this.item != null && this.item.getButtonTitle() != null) {
            if (this.textPopupMessage != null) {
                this.textPopupMessage.setMaxLines(this.getAttachmentTextMaxLine());
            }
            this.buttonPushBotPopupButton.setVisibility(0);
            this.textPushBotPopupButton.setText((CharSequence)this.item.getButtonTitle());
        } else {
            if (this.textPopupMessage != null) {
                this.textPopupMessage.setMaxLines(this.getDefaultTextMaxLine());
            }
            this.buttonPushBotPopupButton.setVisibility(8);
        }
    }
}

