/*
 * Decompiled with CFR 0.152.
 */
package com.zoyi.channel.plugin.android.util;

import android.content.ContentResolver;
import android.content.Context;
import android.net.Uri;
import android.webkit.MimeTypeMap;
import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.network.InputStreamRequestBody;
import com.zoyi.channel.plugin.android.util.FileUtils;
import com.zoyi.channel.plugin.android.util.io.FilenameUtils;
import com.zoyi.com.annimon.stream.Optional;
import com.zoyi.com.google.gson.Gson;
import com.zoyi.com.google.gson.GsonBuilder;
import com.zoyi.okhttp3.MediaType;
import com.zoyi.okhttp3.MultipartBody;
import com.zoyi.okhttp3.RequestBody;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

public class RequestUtils {
    Map<String, Object> map;
    private Gson gson;

    private Gson getGson() {
        if (this.gson == null) {
            this.gson = new GsonBuilder().serializeNulls().create();
        }
        return this.gson;
    }

    public static RequestUtils form() {
        RequestUtils requestUtils = new RequestUtils();
        requestUtils.map = new HashMap<String, Object>();
        return requestUtils;
    }

    public static RequestUtils form(Map<String, Object> map) {
        return RequestUtils.form(map, false);
    }

    public static RequestUtils form(Map<String, Object> map, boolean allowNullValue) {
        RequestUtils requestUtils = RequestUtils.form();
        if (map != null) {
            for (Map.Entry<String, Object> kvp : map.entrySet()) {
                if (kvp.getKey() == null || !allowNullValue && kvp.getValue() == null) continue;
                requestUtils.set(kvp.getKey(), kvp.getValue());
            }
        }
        return requestUtils;
    }

    public RequestUtils set(String key, Object value) {
        if (this.map == null) {
            throw new NullPointerException("You must call 'form' first");
        }
        this.map.put(key, value);
        return this;
    }

    public RequestBody create() {
        if (this.map == null) {
            throw new NullPointerException("You must call 'form' first");
        }
        return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)this.getGson().toJson(this.map));
    }

    public static MultipartBody.Part makeMultipart(Uri uri) {
        String path = FileUtils.getPath(ChannelIO.getAppContext(), uri);
        File file = new File(path);
        if (!file.exists()) {
            return null;
        }
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String type = mimeTypeMap.getMimeTypeFromExtension(FilenameUtils.getExtension(file.getName().toLowerCase()));
        if (type == null) {
            return null;
        }
        ContentResolver contentResolver = (ContentResolver)Optional.ofNullable((Object)ChannelIO.getAppContext()).map(Context::getContentResolver).orElse(null);
        if (contentResolver == null) {
            return null;
        }
        InputStreamRequestBody requestFile = new InputStreamRequestBody(MediaType.parse((String)"multipart/form-data"), contentResolver, uri);
        return MultipartBody.Part.createFormData((String)"file", (String)file.getName(), (RequestBody)requestFile);
    }
}

