package com.zoyi.channel.plugin.android.util;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.support.annotation.Nullable;
import android.text.TextUtils;

import com.zoyi.channel.plugin.android.ChannelIO;
import com.zoyi.channel.plugin.android.ChannelPluginListener;
import com.zoyi.channel.plugin.android.global.ChannelFileProvider;
import com.zoyi.channel.plugin.android.global.Const;
import com.zoyi.channel.plugin.android.util.message_format.type.LinkType;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class Executor {

  public static boolean takePhoto(Activity activity) {
    Intent takePictureIntent = new Intent(MediaStore.ACTION_IMAGE_CAPTURE);

    File photoFile = getPhotoFile(activity);
    if (photoFile == null) {
      return false;
    }

    tempPhotoFile = photoFile;

    takePictureIntent.putExtra(
        MediaStore.EXTRA_OUTPUT,
        ChannelFileProvider.getUriForFile(activity, photoFile));

    if (takePictureIntent.resolveActivity(activity.getPackageManager()) != null) {
      activity.startActivityForResult(takePictureIntent, Const.REQUEST_TAKE_PHOTO);
      return true;
    }
    return false;
  }

  public static void startFileMediaScan(Activity activity, String filePath) {
    startFileMediaScan(activity, new File(filePath));
  }

  public static void startFileMediaScan(Activity activity, File file) {
    Intent mediaScanIntent = new Intent(Intent.ACTION_MEDIA_SCANNER_SCAN_FILE);

    mediaScanIntent.setData(Uri.fromFile(file));
    activity.sendBroadcast(mediaScanIntent);
  }

  public static void executeLinkAction(@Nullable Context context, @Nullable String link, LinkType linkType) {
    if (context != null && link != null) {
      boolean handleLink = false;
      ChannelPluginListener channelPluginListener = ChannelIO.getChannelPluginListener();

      if (channelPluginListener != null) {
        handleLink = channelPluginListener.onClickChatLink(link);
      }

      if (!handleLink) {
        switch (linkType) {
          case URL:
            IntentUtils.setUrl(context, link).startActivity();
            break;

          case PHONE:
            IntentUtils.setPhone(context, link).startActivity();
            break;

          case EMAIL:
            IntentUtils.setEmail(context, link).startActivity();
            break;
        }
      }
    }
  }

  public static void executeRedirectUrlAction(@Nullable Context context, @Nullable String url) {
    if (context != null && url != null) {
      boolean handleRedirectUrl = false;
      ChannelPluginListener channelPluginListener = ChannelIO.getChannelPluginListener();

      if (channelPluginListener != null) {
        handleRedirectUrl = channelPluginListener.onClickRedirectUrl(url);
      }

      if (!handleRedirectUrl) {
        IntentUtils.setUrl(context, url).startActivity();
      }
    }
  }

  private static File tempPhotoFile = null;

  public static File getTempPhotoFile() {
    return tempPhotoFile;
  }

  @SuppressLint("SimpleDateFormat")
  private static File getPhotoFile(Context context) {
    try {
      String timeStamp = new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date());

      return File.createTempFile(timeStamp, ".jpg", context.getCacheDir());
    } catch (IOException e) {
      e.printStackTrace();
    }
    return null;
  }

  public static void call(Context context, String phoneNumber) {
    if (TextUtils.isEmpty(phoneNumber)) {
      return;
    }

    Intent intent = new Intent(Intent.ACTION_DIAL);

    intent.setData(Uri.parse("tel:" + phoneNumber));

    if (intent.resolveActivity(context.getPackageManager()) != null) {
      context.startActivity(intent);
    }
  }
}
